"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatSelectEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _fieldTypes = require("@kbn/field-types");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _format_editor = require("./format_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getFieldTypeFormatsList = (fieldType, defaultFieldFormat, fieldFormats) => {
  const formatsByType = fieldFormats.getByFieldType(fieldType).map(({
    id,
    title
  }) => ({
    id,
    title
  }));
  return [{
    id: '',
    defaultFieldFormat,
    title: _i18n.i18n.translate('indexPatternFieldEditor.defaultFormatDropDown', {
      defaultMessage: '- Default -'
    })
  }, ...formatsByType];
};
class FormatSelectEditor extends _react.PureComponent {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onFormatChange", (formatId, params) => this.props.onChange(formatId ? {
      id: formatId,
      params: params || {}
    } : undefined));
    (0, _defineProperty2.default)(this, "onFormatParamsChange", newParams => {
      const {
        fieldFormatId
      } = this.state;
      this.onFormatChange(fieldFormatId, newParams);
    });
    const {
      fieldFormats,
      esTypes
    } = props;
    const kbnType = (0, _fieldTypes.castEsToKbnFieldTypeName)(esTypes[0] || 'keyword');
    this.state = {
      fieldTypeFormats: getFieldTypeFormatsList(kbnType, fieldFormats.getDefaultType(kbnType, esTypes), fieldFormats),
      kbnType
    };
  }
  render() {
    const {
      fieldFormatEditors,
      onError,
      value,
      fieldFormats,
      esTypes
    } = this.props;
    const fieldFormatId = value === null || value === void 0 ? void 0 : value.id;
    const {
      kbnType
    } = this.state;
    const {
      fieldTypeFormats
    } = this.state;
    const defaultFormat = fieldTypeFormats[0].defaultFieldFormat.title;

    // get current formatter for field, provides default if none exists
    const format = value !== null && value !== void 0 && value.id ? fieldFormats.getInstance(value === null || value === void 0 ? void 0 : value.id, value === null || value === void 0 ? void 0 : value.params) : fieldFormats.getDefaultInstance(kbnType, esTypes);
    const fieldFormatParams = format.params();
    const label = defaultFormat ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternFieldEditor.defaultFormatHeader",
      defaultMessage: "Format (Default: {defaultFormat})",
      values: {
        defaultFormat: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, defaultFormat)
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternFieldEditor.formatHeader",
      defaultMessage: "Format"
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      value: fieldFormatId || '',
      options: fieldTypeFormats.map(fmt => {
        return {
          value: fmt.id || '',
          text: fmt.title
        };
      }),
      "data-test-subj": "editorSelectedFormatId",
      onChange: e => {
        this.onFormatChange(e.target.value);
      }
    })), fieldFormatId ? /*#__PURE__*/_react.default.createElement(_format_editor.FormatEditor, {
      fieldType: kbnType,
      fieldFormat: format,
      fieldFormatId: fieldFormatId,
      fieldFormatParams: fieldFormatParams,
      fieldFormatEditors: fieldFormatEditors,
      onChange: params => {
        this.onFormatChange(fieldFormatId, params);
      },
      onError: onError
    }) : null);
  }
}
exports.FormatSelectEditor = FormatSelectEditor;