"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableViewDescription = void 0;
var _i18n = require("@kbn/i18n");
var _data_view_wrapper = require("./components/data_view_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getTableViewDescription = getStartServices => ({
  title: _i18n.i18n.translate('data.inspector.table.dataTitle', {
    defaultMessage: 'Data'
  }),
  order: 10,
  help: _i18n.i18n.translate('data.inspector.table..dataDescriptionTooltip', {
    defaultMessage: 'View the data behind the visualization'
  }),
  shouldShow(adapters) {
    return Boolean(adapters.tables);
  },
  component: (0, _data_view_wrapper.getDataViewComponentWrapper)(getStartServices)
});
exports.getTableViewDescription = getTableViewDescription;