"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableSelector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class TableSelector extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "renderTableDropdownItem", (table, index) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: index,
        icon: table === this.props.selectedTable ? 'check' : 'empty',
        onClick: () => {
          this.props.onTableChanged(table);
          this.closePopover();
        },
        "data-test-subj": `inspectorTableChooser${index}`
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.inspector.table.tableLabel",
        defaultMessage: "Table {index}",
        values: {
          index: index + 1
        }
      }));
    });
  }
  render() {
    const currentIndex = this.props.tables.findIndex(table => table === this.props.selectedTable);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.inspector.table.tableSelectorLabel",
      defaultMessage: "Selected:"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "inspectorTableChooser",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "arrowDown",
        iconSide: "right",
        size: "s",
        onClick: this.togglePopover,
        "data-test-subj": "inspectorTableChooser"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.inspector.table.tableLabel",
        defaultMessage: "Table {index}",
        values: {
          index: currentIndex + 1
        }
      })),
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: "downLeft",
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: this.props.tables.map(this.renderTableDropdownItem),
      "data-test-subj": "inspectorTableChooserMenuPanel"
    }))));
  }
}
exports.TableSelector = TableSelector;
(0, _defineProperty2.default)(TableSelector, "propTypes", {
  tables: _propTypes.default.array.isRequired,
  selectedTable: _propTypes.default.object.isRequired,
  onTableChanged: _propTypes.default.func
});