"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDeleteActionDescriptor = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DeleteConfirm = props => {
  const {
    searchSession,
    api,
    onActionDismiss
  } = props;
  const {
    name,
    id
  } = searchSession;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const title = _i18n.i18n.translate('data.mgmt.searchSessions.cancelModal.title', {
    defaultMessage: 'Delete search session'
  });
  const confirm = _i18n.i18n.translate('data.mgmt.searchSessions.cancelModal.deleteButton', {
    defaultMessage: 'Delete'
  });
  const cancel = _i18n.i18n.translate('data.mgmt.searchSessions.cancelModal.cancelButton', {
    defaultMessage: 'Cancel'
  });
  const message = _i18n.i18n.translate('data.mgmt.searchSessions.cancelModal.message', {
    defaultMessage: `Deleting the search session \'{name}\' deletes all cached results.`,
    values: {
      name
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: title,
    onCancel: onActionDismiss,
    onConfirm: async () => {
      setIsLoading(true);
      await api.sendDelete(id);
      onActionDismiss();
    },
    confirmButtonText: confirm,
    confirmButtonDisabled: isLoading,
    cancelButtonText: cancel,
    defaultFocusedButton: "confirm",
    buttonColor: "danger"
  }, message);
};
const createDeleteActionDescriptor = (api, uiSession, core) => ({
  iconType: 'trash',
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.mgmt.searchSessions.actionDelete",
    defaultMessage: "Delete"
  }),
  onClick: async () => {
    const ref = core.overlays.openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(DeleteConfirm, {
      onActionDismiss: () => ref === null || ref === void 0 ? void 0 : ref.close(),
      searchSession: uiSession,
      api: api
    }), {
      theme$: core.theme.theme$
    }));
    await ref.onClose;
  }
});
exports.createDeleteActionDescriptor = createDeleteActionDescriptor;