"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _main = require("../components/main");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const renderApp = (elem, {
  i18n,
  uiSettings,
  ...homeDeps
}) => {
  if (!elem) {
    return () => undefined;
  }

  // uiSettings is required by the listing table to format dates in the timezone from Settings
  const {
    Provider: KibanaReactContextProvider
  } = (0, _public.createKibanaReactContext)({
    uiSettings
  });
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, {
    theme: homeDeps.core.theme,
    i18n: i18n
  }, /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(_main.SearchSessionsMgmtMain, (0, _extends2.default)({}, homeDeps, {
    timezone: uiSettings.get('dateFormat:tz')
  })))), elem);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(elem);
  };
};
exports.renderApp = renderApp;