"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDashboardSavedObjectType = void 0;
var _configSchema = require("@kbn/config-schema");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _dashboard_saved_object_migrations = require("./migrations/dashboard_saved_object_migrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createDashboardSavedObjectType = ({
  migrationDeps
}) => ({
  name: 'dashboard',
  indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'multiple-isolated',
  convertToMultiNamespaceTypeVersion: '8.0.0',
  management: {
    icon: 'dashboardApp',
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl(obj) {
      return {
        path: `/app/dashboards#/view/${encodeURIComponent(obj.id)}`,
        uiCapabilitiesPath: 'dashboard.show'
      };
    }
  },
  mappings: {
    properties: {
      description: {
        type: 'text'
      },
      hits: {
        type: 'integer',
        index: false,
        doc_values: false
      },
      kibanaSavedObjectMeta: {
        properties: {
          searchSourceJSON: {
            type: 'text',
            index: false
          }
        }
      },
      optionsJSON: {
        type: 'text',
        index: false
      },
      panelsJSON: {
        type: 'text',
        index: false
      },
      refreshInterval: {
        properties: {
          display: {
            type: 'keyword',
            index: false,
            doc_values: false
          },
          pause: {
            type: 'boolean',
            index: false,
            doc_values: false
          },
          section: {
            type: 'integer',
            index: false,
            doc_values: false
          },
          value: {
            type: 'integer',
            index: false,
            doc_values: false
          }
        }
      },
      controlGroupInput: {
        properties: {
          controlStyle: {
            type: 'keyword',
            index: false,
            doc_values: false
          },
          chainingSystem: {
            type: 'keyword',
            index: false,
            doc_values: false
          },
          panelsJSON: {
            type: 'text',
            index: false
          },
          ignoreParentSettingsJSON: {
            type: 'text',
            index: false
          }
        }
      },
      timeFrom: {
        type: 'keyword',
        index: false,
        doc_values: false
      },
      timeRestore: {
        type: 'boolean',
        index: false,
        doc_values: false
      },
      timeTo: {
        type: 'keyword',
        index: false,
        doc_values: false
      },
      title: {
        type: 'text'
      },
      version: {
        type: 'integer'
      }
    }
  },
  schemas: {
    '8.9.0': _configSchema.schema.object({
      // General
      title: _configSchema.schema.string(),
      description: _configSchema.schema.string({
        defaultValue: ''
      }),
      // Search
      kibanaSavedObjectMeta: _configSchema.schema.object({
        searchSourceJSON: _configSchema.schema.maybe(_configSchema.schema.string())
      }),
      // Time
      timeRestore: _configSchema.schema.maybe(_configSchema.schema.boolean()),
      timeFrom: _configSchema.schema.maybe(_configSchema.schema.string()),
      timeTo: _configSchema.schema.maybe(_configSchema.schema.string()),
      refreshInterval: _configSchema.schema.maybe(_configSchema.schema.object({
        pause: _configSchema.schema.boolean(),
        value: _configSchema.schema.number(),
        display: _configSchema.schema.maybe(_configSchema.schema.string()),
        section: _configSchema.schema.maybe(_configSchema.schema.number())
      })),
      // Dashboard Content
      controlGroupInput: _configSchema.schema.maybe(_configSchema.schema.object({
        panelsJSON: _configSchema.schema.maybe(_configSchema.schema.string()),
        controlStyle: _configSchema.schema.maybe(_configSchema.schema.string()),
        chainingSystem: _configSchema.schema.maybe(_configSchema.schema.string()),
        ignoreParentSettingsJSON: _configSchema.schema.maybe(_configSchema.schema.string())
      })),
      panelsJSON: _configSchema.schema.string({
        defaultValue: '[]'
      }),
      optionsJSON: _configSchema.schema.string({
        defaultValue: '{}'
      }),
      // Legacy
      hits: _configSchema.schema.maybe(_configSchema.schema.number()),
      version: _configSchema.schema.maybe(_configSchema.schema.number())
    })
  },
  migrations: () => (0, _dashboard_saved_object_migrations.createDashboardSavedObjectTypeMigrations)(migrationDeps)
});
exports.createDashboardSavedObjectType = createDashboardSavedObjectType;