"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardListingEmptyPrompt = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _dashboard_listing_strings = require("./_dashboard_listing_strings");
var _plugin_services = require("../services/plugin_services");
var _confirm_overlays = require("./confirm_overlays");
var _dashboard_backup_service = require("../services/dashboard_backup/dashboard_backup_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardListingEmptyPrompt = ({
  useSessionStorageIntegration,
  setUnsavedDashboardIds,
  unsavedDashboardIds,
  goToDashboard,
  createItem,
  disableCreateDashboardButton
}) => {
  const {
    application,
    dashboardBackup,
    dashboardCapabilities: {
      showWriteControls
    }
  } = _plugin_services.pluginServices.getServices();
  const isEditingFirstDashboard = (0, _react.useMemo)(() => useSessionStorageIntegration && unsavedDashboardIds.length === 1, [unsavedDashboardIds.length, useSessionStorageIntegration]);
  const getEmptyAction = (0, _react.useCallback)(() => {
    if (!isEditingFirstDashboard) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: createItem,
        fill: true,
        iconType: "plusInCircle",
        "data-test-subj": "newItemButton",
        disabled: disableCreateDashboardButton
      }, _dashboard_listing_strings.noItemsStrings.getCreateNewDashboardText());
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "danger",
      onClick: () => (0, _confirm_overlays.confirmDiscardUnsavedChanges)(() => {
        dashboardBackup.clearState(_dashboard_backup_service.DASHBOARD_PANELS_UNSAVED_ID);
        setUnsavedDashboardIds(dashboardBackup.getDashboardIdsWithUnsavedChanges());
      }),
      "data-test-subj": "discardDashboardPromptButton",
      "aria-label": _dashboard_listing_strings.dashboardUnsavedListingStrings.getDiscardAriaLabel((0, _dashboard_listing_strings.getNewDashboardTitle)())
    }, _dashboard_listing_strings.dashboardUnsavedListingStrings.getDiscardTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "pencil",
      color: "primary",
      "data-test-subj": "newItemButton",
      onClick: () => goToDashboard(),
      "aria-label": _dashboard_listing_strings.dashboardUnsavedListingStrings.getEditAriaLabel((0, _dashboard_listing_strings.getNewDashboardTitle)())
    }, _dashboard_listing_strings.dashboardUnsavedListingStrings.getEditTitle())));
  }, [isEditingFirstDashboard, createItem, disableCreateDashboardButton, dashboardBackup, goToDashboard, setUnsavedDashboardIds]);
  if (!showWriteControls) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "glasses",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        id: "dashboardListingHeading",
        "data-test-subj": "emptyListPrompt"
      }, _dashboard_listing_strings.noItemsStrings.getReadonlyTitle()),
      body: /*#__PURE__*/_react.default.createElement("p", null, _dashboard_listing_strings.noItemsStrings.getReadonlyBody())
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "dashboardApp",
    title: /*#__PURE__*/_react.default.createElement("h1", {
      id: "dashboardListingHeading",
      "data-test-subj": "emptyListPrompt"
    }, isEditingFirstDashboard ? _dashboard_listing_strings.noItemsStrings.getReadEditInProgressTitle() : _dashboard_listing_strings.noItemsStrings.getReadEditTitle()),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _dashboard_listing_strings.noItemsStrings.getReadEditDashboardDescription()), !isEditingFirstDashboard && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.listing.createNewDashboard.newToKibanaDescription",
      defaultMessage: "New to Kibana? {sampleDataInstallLink} to take a test drive.",
      values: {
        sampleDataInstallLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => application.navigateToApp('home', {
            path: '#/tutorial_directory/sampleData'
          })
        }, _dashboard_listing_strings.noItemsStrings.getSampleDataLinkText())
      }
    }))),
    actions: getEmptyAction()
  });
};
exports.DashboardListingEmptyPrompt = DashboardListingEmptyPrompt;