"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardListItemLink = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _dashboard_constants = require("../../dashboard_constants");
var _plugin_services = require("../../services/plugin_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDashboardListItemLink = (kbnUrlStateStorage, id, timeRestore) => {
  const {
    application: {
      getUrlForApp
    },
    settings: {
      uiSettings
    }
  } = _plugin_services.pluginServices.getServices();
  const useHash = uiSettings.get('state:storeInSessionStorage'); // use hash

  let url = getUrlForApp(_dashboard_constants.DASHBOARD_APP_ID, {
    path: `#${(0, _dashboard_constants.createDashboardEditUrl)(id)}`
  });
  const globalStateInUrl = kbnUrlStateStorage.get(_dashboard_constants.GLOBAL_STATE_STORAGE_KEY) || {};
  if (timeRestore) {
    delete globalStateInUrl.time;
    delete globalStateInUrl.refreshInterval;
  }
  url = (0, _public.setStateToKbnUrl)(_dashboard_constants.GLOBAL_STATE_STORAGE_KEY, globalStateInUrl, {
    useHash
  }, url);
  return url;
};
exports.getDashboardListItemLink = getDashboardListItemLink;