"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReplacePanelFlyout = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _plugin_services = require("../services/plugin_services");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ReplacePanelFlyout extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "lastToast", {
      id: 'panelReplaceToast'
    });
    (0, _defineProperty2.default)(this, "showToast", name => {
      const {
        notifications: {
          toasts
        }
      } = _plugin_services.pluginServices.getServices();

      // To avoid the clutter of having toast messages cover flyout
      // close previous toast message before creating a new one
      if (this.lastToast) {
        toasts.remove(this.lastToast);
      }
      this.lastToast = toasts.addSuccess({
        title: _dashboard_actions_strings.dashboardReplacePanelActionStrings.getSuccessMessage(name),
        'data-test-subj': 'addObjectToContainerSuccess'
      });
    });
    (0, _defineProperty2.default)(this, "onReplacePanel", async (savedObjectId, type, name) => {
      const {
        panelToRemove,
        container
      } = this.props;
      const id = await container.replaceEmbeddable(panelToRemove.id, {
        savedObjectId
      }, type, true);
      container.setHighlightPanelId(id);
      this.showToast(name);
      this.props.onClose();
    });
  }
  render() {
    const {
      embeddable: {
        getEmbeddableFactories
      }
    } = _plugin_services.pluginServices.getServices();
    const SavedObjectFinder = this.props.savedObjectsFinder;
    const savedObjectsFinder = /*#__PURE__*/_react.default.createElement(SavedObjectFinder, {
      noItemsMessage: _dashboard_actions_strings.dashboardReplacePanelActionStrings.getNoMatchingObjectsMessage(),
      savedObjectMetaData: [...getEmbeddableFactories()].filter(embeddableFactory => Boolean(embeddableFactory.savedObjectMetaData) && !embeddableFactory.isContainerType).map(({
        savedObjectMetaData
      }) => savedObjectMetaData),
      showFilter: true,
      onChoose: this.onReplacePanel
    });
    const panelToReplace = 'Replace panel ' + this.props.panelToRemove.getTitle() + ' with:';
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement("span", null, panelToReplace)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, savedObjectsFinder));
  }
}
exports.ReplacePanelFlyout = ReplacePanelFlyout;