"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LibraryNotificationAction = exports.ACTION_LIBRARY_NOTIFICATION = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _library_notification_popover = require("./library_notification_popover");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_LIBRARY_NOTIFICATION = 'ACTION_LIBRARY_NOTIFICATION';
exports.ACTION_LIBRARY_NOTIFICATION = ACTION_LIBRARY_NOTIFICATION;
class LibraryNotificationAction {
  constructor(unlinkAction) {
    (0, _defineProperty2.default)(this, "id", ACTION_LIBRARY_NOTIFICATION);
    (0, _defineProperty2.default)(this, "type", ACTION_LIBRARY_NOTIFICATION);
    (0, _defineProperty2.default)(this, "order", 1);
    (0, _defineProperty2.default)(this, "displayName", _dashboard_actions_strings.dashboardLibraryNotificationStrings.getDisplayName());
    (0, _defineProperty2.default)(this, "icon", 'folderCheck');
    (0, _defineProperty2.default)(this, "MenuItem", ({
      context
    }) => {
      const {
        embeddable
      } = context;
      return /*#__PURE__*/_react.default.createElement(_library_notification_popover.LibraryNotificationPopover, {
        unlinkAction: this.unlinkAction,
        displayName: this.displayName,
        context: context,
        icon: this.getIconType({
          embeddable
        }),
        id: this.id
      });
    });
    (0, _defineProperty2.default)(this, "isCompatible", async ({
      embeddable
    }) => {
      var _embeddable$getInput;
      return !(0, _public.isErrorEmbeddable)(embeddable) && embeddable.getRoot().isContainer && ((_embeddable$getInput = embeddable.getInput()) === null || _embeddable$getInput === void 0 ? void 0 : _embeddable$getInput.viewMode) !== _public.ViewMode.VIEW && (0, _public.isReferenceOrValueEmbeddable)(embeddable) && embeddable.inputIsRefType(embeddable.getInput());
    });
    (0, _defineProperty2.default)(this, "execute", async () => {});
    this.unlinkAction = unlinkAction;
  }
  getDisplayName({
    embeddable
  }) {
    if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
      throw new _public2.IncompatibleActionError();
    }
    return this.displayName;
  }
  getIconType({
    embeddable
  }) {
    if (!embeddable.getRoot() || !embeddable.getRoot().isContainer) {
      throw new _public2.IncompatibleActionError();
    }
    return this.icon;
  }
}
exports.LibraryNotificationAction = LibraryNotificationAction;