"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyToDashboardModal = CopyToDashboardModal;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/presentation-util-plugin/public");
var _plugin_services = require("../services/plugin_services");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _dashboard_constants = require("../dashboard_constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardPicker = (0, _public2.withSuspense)(_public2.LazyDashboardPicker);
function CopyToDashboardModal({
  dashboardId,
  embeddable,
  closeModal
}) {
  const {
    embeddable: {
      getStateTransfer
    },
    dashboardCapabilities: {
      createNew: canCreateNew,
      showWriteControls: canEditExisting
    }
  } = _plugin_services.pluginServices.getServices();
  const stateTransfer = getStateTransfer();
  const [dashboardOption, setDashboardOption] = (0, _react.useState)('existing');
  const [selectedDashboard, setSelectedDashboard] = (0, _react.useState)(null);
  const onSubmit = (0, _react.useCallback)(() => {
    const dashboard = embeddable.getRoot();
    const panelToCopy = dashboard.getInput().panels[embeddable.id];
    if (!panelToCopy) {
      throw new _public.PanelNotFoundError();
    }
    const state = {
      type: embeddable.type,
      input: {
        ...(0, _lodash.omit)(panelToCopy.explicitInput, 'id')
      },
      size: {
        width: panelToCopy.gridData.w,
        height: panelToCopy.gridData.h
      }
    };
    const path = dashboardOption === 'existing' && selectedDashboard ? `#${(0, _dashboard_constants.createDashboardEditUrl)(selectedDashboard.id, true)}` : `#${_dashboard_constants.CREATE_NEW_DASHBOARD_URL}`;
    closeModal();
    stateTransfer.navigateToWithEmbeddablePackage('dashboards', {
      state,
      path
    });
  }, [dashboardOption, embeddable, selectedDashboard, stateTransfer, closeModal]);
  const titleId = 'copyToDashboardTitle';
  const descriptionId = 'copyToDashboardDescription';
  return /*#__PURE__*/_react.default.createElement("div", {
    role: "dialog",
    "aria-modal": "true",
    "aria-labelledby": titleId,
    "aria-describedby": descriptionId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: titleId,
    component: "h2"
  }, _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getDisplayName())), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "add-to-dashboard-options"
  }, canEditExisting && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    checked: dashboardOption === 'existing',
    "data-test-subj": "add-to-existing-dashboard-option",
    id: "existing-dashboard-option",
    name: "dashboard-option",
    label: _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getExistingDashboardOption(),
    onChange: () => setDashboardOption('existing')
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(DashboardPicker, {
    isDisabled: dashboardOption !== 'existing',
    idsToOmit: dashboardId ? [dashboardId] : undefined,
    onChange: dashboard => {
      setSelectedDashboard(dashboard);
      setDashboardOption('existing');
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), canCreateNew && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    checked: dashboardOption === 'new',
    "data-test-subj": "add-to-new-dashboard-option",
    id: "new-dashboard-option",
    name: "dashboard-option",
    disabled: !dashboardId,
    label: _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getNewDashboardOption(),
    onChange: () => setDashboardOption('new')
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelCopyToButton",
    onClick: () => closeModal()
  }, _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getCancelButtonName()), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "confirmCopyToButton",
    onClick: onSubmit,
    disabled: dashboardOption === 'existing' && !selectedDashboard
  }, _dashboard_actions_strings.dashboardCopyToDashboardActionStrings.getAcceptButtonName())));
}