"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FollowerIndexEdit = void 0;
var _reactRedux = require("react-redux");
var _constants = require("../../constants");
var _selectors = require("../../store/selectors");
var _actions = require("../../store/actions");
var _follower_index_edit = require("./follower_index_edit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scope = _constants.SECTIONS.FOLLOWER_INDEX;
const mapStateToProps = state => ({
  apiStatus: {
    get: (0, _selectors.getApiStatus)(`${scope}-get`)(state),
    save: (0, _selectors.getApiStatus)(`${scope}-save`)(state)
  },
  apiError: {
    get: (0, _selectors.getApiError)(`${scope}-get`)(state),
    save: (0, _selectors.getApiError)(`${scope}-save`)(state)
  },
  followerIndexId: (0, _selectors.getSelectedFollowerIndexId)('edit')(state),
  followerIndex: (0, _selectors.getSelectedFollowerIndex)('edit')(state)
});
const mapDispatchToProps = dispatch => ({
  getFollowerIndex: id => dispatch((0, _actions.getFollowerIndex)(id)),
  selectFollowerIndex: id => dispatch((0, _actions.selectEditFollowerIndex)(id)),
  saveFollowerIndex: (id, followerIndex) => dispatch((0, _actions.saveFollowerIndex)(id, followerIndex, true)),
  clearApiError: () => {
    dispatch((0, _actions.clearApiError)(`${scope}-get`));
    dispatch((0, _actions.clearApiError)(`${scope}-save`));
  }
});
const FollowerIndexEdit = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_follower_index_edit.FollowerIndexEdit);
exports.FollowerIndexEdit = FollowerIndexEdit;