"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternAdd = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _breadcrumbs = require("../../services/breadcrumbs");
var _components = require("../../components");
var _shared_imports = require("../../../shared_imports");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AutoFollowPatternAdd extends _react.PureComponent {
  componentDidMount() {
    (0, _breadcrumbs.setBreadcrumbs)([(0, _breadcrumbs.listBreadcrumb)('/auto_follow_patterns'), _breadcrumbs.addBreadcrumb]);
  }
  componentWillUnmount() {
    this.props.clearApiError();
  }
  render() {
    const {
      saveAutoFollowPattern,
      apiStatus,
      apiError,
      match: {
        url: currentUrl
      }
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_components.RemoteClustersProvider, null, ({
      isLoading,
      error,
      remoteClusters
    }) => {
      if (isLoading) {
        return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternCreateForm.loadingRemoteClustersMessage",
          defaultMessage: "Loading remote clusters\u2026"
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        restrictWidth: true,
        style: {
          width: '100%'
        }
      }, /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternPageTitle, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPattern.addTitle",
          defaultMessage: "Add auto-follow pattern"
        })
      }), /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternForm, {
        apiStatus: apiStatus,
        apiError: apiError,
        currentUrl: currentUrl,
        remoteClusters: error ? [] : remoteClusters,
        saveAutoFollowPattern: saveAutoFollowPattern,
        saveButtonLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternCreateForm.saveButtonLabel",
          defaultMessage: "Create"
        })
      }));
    });
  }
}
exports.AutoFollowPatternAdd = AutoFollowPatternAdd;
(0, _defineProperty2.default)(AutoFollowPatternAdd, "propTypes", {
  saveAutoFollowPattern: _propTypes.default.func.isRequired,
  clearApiError: _propTypes.default.func.isRequired,
  apiError: _propTypes.default.object,
  apiStatus: _propTypes.default.string.isRequired
});