"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SPACES_EXTENSION_ID = exports.SECURITY_EXTENSION_ID = exports.ENCRYPTION_EXTENSION_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * The SavedObjectsExtensions interface contains the intefaces for three
 * extensions to the saved objects repository. These extensions augment
 * the funtionality of the saved objects repository to provide encryption,
 * security, and spaces features.
 */

const ENCRYPTION_EXTENSION_ID = 'encryptedSavedObjects';
exports.ENCRYPTION_EXTENSION_ID = ENCRYPTION_EXTENSION_ID;
const SECURITY_EXTENSION_ID = 'security';
exports.SECURITY_EXTENSION_ID = SECURITY_EXTENSION_ID;
const SPACES_EXTENSION_ID = 'spaces';
exports.SPACES_EXTENSION_ID = SPACES_EXTENSION_ID;