"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setMetaMappingMigrationComplete = exports.setMetaDocMigrationStarted = exports.setMetaDocMigrationComplete = exports.removePropertiesFromV2 = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const setMetaMappingMigrationComplete = ({
  meta,
  versions
}) => {
  return {
    ...meta,
    mappingVersions: {
      ...versions
    }
  };
};
exports.setMetaMappingMigrationComplete = setMetaMappingMigrationComplete;
const setMetaDocMigrationStarted = ({
  meta
}) => {
  return {
    ...meta,
    migrationState: {
      convertingDocuments: true
    }
  };
};
exports.setMetaDocMigrationStarted = setMetaDocMigrationStarted;
const setMetaDocMigrationComplete = ({
  meta,
  versions
}) => {
  return {
    ...meta,
    docVersions: {
      ...versions
    },
    migrationState: {
      convertingDocuments: false
    }
  };
};
exports.setMetaDocMigrationComplete = setMetaDocMigrationComplete;
const removePropertiesFromV2 = meta => {
  const cleaned = {
    ...meta
  };
  delete cleaned.indexTypesMap;
  delete cleaned.migrationMappingPropertyHashes;
  return cleaned;
};
exports.removePropertiesFromV2 = removePropertiesFromV2;