"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.outdatedDocumentsSearchBulkIndex = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _constants = require("../../../common/constants");
var _helpers = require("../../../model/helpers");
var _actions = require("../../actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const outdatedDocumentsSearchBulkIndex = (state, res, context) => {
  if (Either.isLeft(res)) {
    if ((0, _actions.isTypeof)(res.left, 'request_entity_too_large_exception')) {
      return {
        ...state,
        controlState: 'FATAL',
        reason: _constants.FATAL_REASON_REQUEST_ENTITY_TOO_LARGE
      };
    } else if ((0, _actions.isTypeof)(res.left, 'target_index_had_write_block') || (0, _actions.isTypeof)(res.left, 'index_not_found_exception')) {
      // we fail on these errors since the target index will never get
      // deleted and should only have a write block if a newer version of
      // Kibana started an upgrade
      (0, _helpers.throwBadResponse)(state, res.left);
    } else {
      (0, _helpers.throwBadResponse)(state, res.left);
    }
  }
  if (state.currentBatch + 1 < state.bulkOperationBatches.length) {
    return {
      ...state,
      controlState: 'OUTDATED_DOCUMENTS_SEARCH_BULK_INDEX',
      currentBatch: state.currentBatch + 1
    };
  }
  return {
    ...state,
    controlState: 'OUTDATED_DOCUMENTS_SEARCH_READ',
    corruptDocumentIds: [],
    transformErrors: [],
    hasTransformedDocs: true
  };
};
exports.outdatedDocumentsSearchBulkIndex = outdatedDocumentsSearchBulkIndex;