"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateTypeStatuses = calculateTypeStatuses;
exports.createWaitGroupMap = createWaitGroupMap;
exports.getCurrentIndexTypesMap = getCurrentIndexTypesMap;
exports.getIndicesInvolvedInRelocation = getIndicesInvolvedInRelocation;
exports.indexMapToIndexTypesMap = indexMapToIndexTypesMap;
exports.waitGroup = waitGroup;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");
var _kibana_migrator_constants = require("./kibana_migrator_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// even though this utility class is present in @kbn/kibana-utils-plugin, we can't easily import it from Core
// aka. one does not simply reuse code
class Defer {
  constructor() {
    (0, _defineProperty2.default)(this, "resolve", void 0);
    (0, _defineProperty2.default)(this, "reject", void 0);
    (0, _defineProperty2.default)(this, "promise", new Promise((resolve, reject) => {
      this.resolve = resolve;
      this.reject = reject;
    }));
  }
}
function waitGroup() {
  return new Defer();
}
function createWaitGroupMap(keys) {
  if (!(keys !== null && keys !== void 0 && keys.length)) {
    return {};
  }
  const defers = keys.map(() => waitGroup());

  // every member of the WaitGroup will wait for all members to resolve
  const all = Promise.all(defers.map(({
    promise
  }) => promise));
  return keys.reduce((acc, indexName, i) => {
    const {
      resolve,
      reject
    } = defers[i];
    acc[indexName] = {
      resolve,
      reject,
      promise: all
    };
    return acc;
  }, {});
}
async function getCurrentIndexTypesMap({
  client,
  mainIndex,
  defaultIndexTypesMap,
  logger,
  retryDelay = 2500
}) {
  try {
    var _Object$values, _Object$values$, _meta$indexTypesMap;
    // check if the main index (i.e. .kibana) exists
    const mapping = await (0, _coreElasticsearchServerInternal.migrationRetryCallCluster)(() => client.indices.getMapping({
      index: mainIndex
    }), logger, retryDelay);

    // main index exists, try to extract the indexTypesMap from _meta
    const meta = (_Object$values = Object.values(mapping)) === null || _Object$values === void 0 ? void 0 : (_Object$values$ = _Object$values[0]) === null || _Object$values$ === void 0 ? void 0 : _Object$values$.mappings._meta;
    return (_meta$indexTypesMap = meta === null || meta === void 0 ? void 0 : meta.indexTypesMap) !== null && _meta$indexTypesMap !== void 0 ? _meta$indexTypesMap : defaultIndexTypesMap;
  } catch (error) {
    var _error$meta;
    if (((_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : _error$meta.statusCode) === 404) {
      logger.debug(`The ${mainIndex} index do NOT exist. Assuming this is a fresh deployment`);
      return undefined;
    } else {
      logger.fatal(`Cannot query the meta information on the ${mainIndex} saved object index`);
      throw error;
    }
  }
}
async function getIndicesInvolvedInRelocation({
  client,
  mainIndex,
  indexTypesMap,
  defaultIndexTypesMap,
  logger
}) {
  const indicesWithRelocatingTypesSet = new Set();
  const currentIndexTypesMap = await getCurrentIndexTypesMap({
    client,
    mainIndex,
    defaultIndexTypesMap,
    logger
  });
  if (!currentIndexTypesMap) {
    // this is a fresh deployment, no indices must be relocated
    return [];
  }
  const typeIndexDistribution = calculateTypeStatuses(currentIndexTypesMap, indexTypesMap);
  Object.values(typeIndexDistribution).filter(({
    status
  }) => status === _kibana_migrator_constants.TypeStatus.Moved).forEach(({
    currentIndex,
    targetIndex
  }) => {
    indicesWithRelocatingTypesSet.add(currentIndex);
    indicesWithRelocatingTypesSet.add(targetIndex);
  });
  return Array.from(indicesWithRelocatingTypesSet);
}
function indexMapToIndexTypesMap(indexMap) {
  return Object.entries(indexMap).reduce((acc, [indexAlias, {
    typeMappings
  }]) => {
    acc[indexAlias] = Object.keys(typeMappings).sort();
    return acc;
  }, {});
}
function calculateTypeStatuses(currentIndexTypesMap, desiredIndexTypesMap) {
  const statuses = {};
  Object.entries(currentIndexTypesMap).forEach(([currentIndex, types]) => {
    types.forEach(type => {
      statuses[type] = {
        currentIndex,
        status: _kibana_migrator_constants.TypeStatus.Removed // type is removed unless we still have it
      };
    });
  });

  Object.entries(desiredIndexTypesMap).forEach(([targetIndex, types]) => {
    types.forEach(type => {
      if (!statuses[type]) {
        statuses[type] = {
          targetIndex,
          status: _kibana_migrator_constants.TypeStatus.Added // type didn't exist, it must be new
        };
      } else {
        statuses[type].targetIndex = targetIndex;
        statuses[type].status = statuses[type].currentIndex === targetIndex ? _kibana_migrator_constants.TypeStatus.Untouched : _kibana_migrator_constants.TypeStatus.Moved;
      }
    });
  });
  return statuses;
}