"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSourceMappingsProperties = void 0;
var _lodash = require("lodash");
var TaskEither = _interopRequireWildcard(require("fp-ts/lib/TaskEither"));
var _pipeable = require("fp-ts/lib/pipeable");
var _build_active_mappings = require("../core/build_active_mappings");
var _update_mappings = require("./update_mappings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

/**
 * This action tries to update the source mappings properties if there are any changes.
 * @internal
 */
const updateSourceMappingsProperties = ({
  client,
  sourceIndex,
  sourceMappings,
  targetMappings
}) => {
  return (0, _pipeable.pipe)((0, _build_active_mappings.diffMappings)(sourceMappings, targetMappings), TaskEither.fromPredicate(changes => !!changes, () => 'update_mappings_succeeded'), TaskEither.swap, TaskEither.orElse(() => (0, _update_mappings.updateMappings)({
    client,
    index: sourceIndex,
    mappings: (0, _lodash.omit)(targetMappings, ['_meta']) // ._meta property will be updated on a later step
  })));
};
exports.updateSourceMappingsProperties = updateSourceMappingsProperties;