"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreVersionedRouter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _core_versioned_route = require("./core_versioned_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

class CoreVersionedRouter {
  static from({
    router,
    defaultHandlerResolutionStrategy,
    isDev,
    useVersionResolutionStrategyForInternalPaths
  }) {
    return new CoreVersionedRouter(router, defaultHandlerResolutionStrategy, isDev, useVersionResolutionStrategyForInternalPaths);
  }
  constructor(router, defaultHandlerResolutionStrategy = 'oldest', isDev = false, useVersionResolutionStrategyForInternalPaths = []) {
    (0, _defineProperty2.default)(this, "routes", new Set());
    (0, _defineProperty2.default)(this, "useVersionResolutionStrategyForInternalPaths", new Map());
    (0, _defineProperty2.default)(this, "registerVersionedRoute", routeMethod => options => {
      const route = _core_versioned_route.CoreVersionedRoute.from({
        router: this,
        method: routeMethod,
        path: options.path,
        options
      });
      this.routes.add(route);
      return route;
    });
    (0, _defineProperty2.default)(this, "get", this.registerVersionedRoute('get'));
    (0, _defineProperty2.default)(this, "delete", this.registerVersionedRoute('delete'));
    (0, _defineProperty2.default)(this, "post", this.registerVersionedRoute('post'));
    (0, _defineProperty2.default)(this, "patch", this.registerVersionedRoute('patch'));
    (0, _defineProperty2.default)(this, "put", this.registerVersionedRoute('put'));
    this.router = router;
    this.defaultHandlerResolutionStrategy = defaultHandlerResolutionStrategy;
    this.isDev = isDev;
    for (const path of useVersionResolutionStrategyForInternalPaths) {
      this.useVersionResolutionStrategyForInternalPaths.set(path, true);
    }
  }
  getRoutes() {
    return [...this.routes].map(route => {
      return {
        path: route.path,
        method: route.method,
        options: route.options,
        handlers: route.getHandlers()
      };
    });
  }
}
exports.CoreVersionedRouter = CoreVersionedRouter;