"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.providers = exports.pluginServices = exports.getStubPluginServices = void 0;
var _public = require("@kbn/presentation-util-plugin/public");
var _controls = require("./controls/controls.story");
var _core = require("./core/core.story");
var _data = require("./data/data.story");
var _data_views = require("./data_views/data_views.story");
var _embeddable = require("./embeddable/embeddable.story");
var _http = require("./http/http.stub");
var _options_list = require("./options_list/options_list.story");
var _overlays = require("./overlays/overlays.stub");
var _plugin_services = require("./plugin_services.story");
var _settings = require("./settings/settings.story");
var _unified_search = require("./unified_search/unified_search.story");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const providers = {
  embeddable: new _public.PluginServiceProvider(_embeddable.embeddableServiceFactory),
  controls: new _public.PluginServiceProvider(_controls.controlsServiceFactory),
  data: new _public.PluginServiceProvider(_data.dataServiceFactory),
  dataViews: new _public.PluginServiceProvider(_data_views.dataViewsServiceFactory),
  http: new _public.PluginServiceProvider(_http.httpServiceFactory),
  optionsList: new _public.PluginServiceProvider(_options_list.optionsListServiceFactory),
  overlays: new _public.PluginServiceProvider(_overlays.overlaysServiceFactory),
  settings: new _public.PluginServiceProvider(_settings.settingsServiceFactory),
  core: new _public.PluginServiceProvider(_core.coreServiceFactory),
  unifiedSearch: new _public.PluginServiceProvider(_unified_search.unifiedSearchServiceFactory)
};
exports.providers = providers;
const pluginServices = new _public.PluginServices();
exports.pluginServices = pluginServices;
const getStubPluginServices = () => {
  pluginServices.setRegistry(_plugin_services.registry.start({}));
  return {
    getControlFactory: pluginServices.getServices().controls.getControlFactory,
    getControlTypes: pluginServices.getServices().controls.getControlTypes
  };
};
exports.getStubPluginServices = getStubPluginServices;