"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mSearch = void 0;
var _schemas = require("../../../common/schemas");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const mSearch = {
  schemas: _schemas.rpcSchemas.mSearch,
  fn: async (ctx, {
    contentTypes: contentTypes,
    query
  }) => {
    const contentTypesWithStorageContext = contentTypes.map(({
      contentTypeId,
      version
    }) => {
      const storageContext = (0, _utils.getStorageContext)({
        contentTypeId,
        version,
        ctx
      });
      return {
        contentTypeId,
        ctx: storageContext
      };
    });
    const result = await ctx.mSearchService.search(contentTypesWithStorageContext, query);
    return {
      contentTypes,
      result
    };
  }
};
exports.mSearch = mSearch;