"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventToDto = exports.dtoToEvent = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const eventToDto = event => {
  const {
    time,
    subject,
    predicate,
    object,
    transaction
  } = event;
  const dto = {
    '@timestamp': new Date(time).toISOString(),
    predicate: predicate[0]
  };
  if (subject) {
    dto.subjectType = subject[0];
    dto.subjectId = subject[1];
  }
  if (predicate[1]) {
    dto.payload = predicate[1];
  }
  if (object) {
    dto.objectType = object[0];
    dto.objectId = object[1];
  }
  if (transaction) {
    dto.txId = transaction;
  }
  return dto;
};
exports.eventToDto = eventToDto;
const dtoToEvent = dto => {
  const {
    '@timestamp': timestamp,
    subjectType,
    subjectId,
    predicate,
    payload,
    objectId,
    objectType,
    txId
  } = dto;
  const event = {
    time: new Date(timestamp).getTime(),
    predicate: payload ? [predicate, payload] : [predicate]
  };
  if (subjectType && subjectId) {
    event.subject = [subjectType, subjectId];
  }
  if (objectType && objectId) {
    event.object = [objectType, objectId];
  }
  if (txId) {
    event.transaction = txId;
  }
  return event;
};
exports.dtoToEvent = dtoToEvent;