"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mSearchSchemas = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
var _search = require("./search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const mSearchSchemas = {
  in: _configSchema.schema.object({
    contentTypes: _configSchema.schema.arrayOf(_configSchema.schema.object({
      contentTypeId: _configSchema.schema.string(),
      version: _constants.versionSchema
    }), {
      minSize: 1
    }),
    query: _search.searchQuerySchema
  }, {
    unknowns: 'forbid'
  }),
  out: _configSchema.schema.object({
    contentTypes: _configSchema.schema.arrayOf(_configSchema.schema.object({
      contentTypeId: _configSchema.schema.string(),
      version: _constants.versionSchema
    })),
    result: _search.searchResultSchema
  }, {
    unknowns: 'forbid'
  })
};
exports.mSearchSchemas = mSearchSchemas;