"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexAutocompleteComponent = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _services = require("../../../services");
var _list_component = require("./list_component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function nonValidIndexType(token) {
  return !(token === '_all' || token[0] !== '_');
}
class IndexAutocompleteComponent extends _list_component.ListComponent {
  constructor(name, parent, multiValued) {
    super(name, (0, _services.getAutocompleteInfo)().getEntityProvider(_services.ENTITIES.INDICES), parent, multiValued);
  }
  validateTokens(tokens) {
    if (!this.multiValued && tokens.length > 1) {
      return false;
    }
    return !_lodash.default.find(tokens, nonValidIndexType);
  }
}
exports.IndexAutocompleteComponent = IndexAutocompleteComponent;