"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleMenu = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ConsoleMenu extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "mouseEnter", () => {
      if (this.state.isPopoverOpen) return;
      this.props.getCurl().then(text => {
        this.setState({
          curlCode: text,
          curlError: null
        });
      }).catch(e => {
        this.setState({
          curlError: e
        });
      });
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "openDocs", async () => {
      this.closePopover();
      const documentation = await this.props.getDocumentation();
      if (!documentation) {
        return;
      }
      window.open(documentation, '_blank');
    });
    (0, _defineProperty2.default)(this, "autoIndent", event => {
      this.closePopover();
      this.props.autoIndent(event);
    });
    this.state = {
      curlCode: '',
      isPopoverOpen: false,
      curlError: null
    };
  }
  async copyAsCurl() {
    const {
      notifications
    } = this.props;
    try {
      await this.copyText(this.state.curlCode);
      notifications.toasts.add({
        title: _i18n.i18n.translate('console.consoleMenu.copyAsCurlMessage', {
          defaultMessage: 'Request copied as cURL'
        })
      });
    } catch (e) {
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('console.consoleMenu.copyAsCurlFailedMessage', {
          defaultMessage: 'Could not copy request as cURL'
        })
      });
    }
  }
  async copyText(text) {
    var _window$navigator;
    if (this.state.curlError) {
      throw this.state.curlError;
    }
    if ((_window$navigator = window.navigator) !== null && _window$navigator !== void 0 && _window$navigator.clipboard) {
      await window.navigator.clipboard.writeText(text);
      return;
    }
    throw new Error('Could not copy to clipboard!');
  }
  render() {
    var _window$navigator2;
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: this.onButtonClick,
      "data-test-subj": "toggleConsoleMenu",
      "aria-label": _i18n.i18n.translate('console.requestOptionsButtonAriaLabel', {
        defaultMessage: 'Request options'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "wrench"
    }));
    const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "Copy as cURL",
      "data-test-subj": "consoleMenuCopyAsCurl",
      id: "ConCopyAsCurl",
      disabled: !((_window$navigator2 = window.navigator) !== null && _window$navigator2 !== void 0 && _window$navigator2.clipboard),
      onClick: () => {
        this.closePopover();
        this.copyAsCurl();
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "console.requestOptions.copyAsUrlButtonLabel",
      defaultMessage: "Copy as cURL"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "Open documentation",
      "data-test-subj": "consoleMenuOpenDocs",
      onClick: () => {
        this.openDocs();
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "console.requestOptions.openDocumentationButtonLabel",
      defaultMessage: "Open documentation"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "consoleMenuAutoIndent",
      key: "Auto indent",
      onClick: this.autoIndent
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "console.requestOptions.autoIndentButtonLabel",
      defaultMessage: "Auto indent"
    }))];
    return /*#__PURE__*/_react.default.createElement("span", {
      onMouseEnter: this.mouseEnter
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "contextMenu",
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: "downLeft"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: items,
      "data-test-subj": "consoleMenu"
    })));
  }
}
exports.ConsoleMenu = ConsoleMenu;