"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnusedColorForNewAssignment = getUnusedColorForNewAssignment;
exports.updateAssignmentsPalette = updateAssignmentsPalette;
exports.updateColorModePalette = updateColorModePalette;
var _container = require("../components/container/container");
var _palettes = require("../palettes");
var _default_color_mapping = require("./default_color_mapping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function updateAssignmentsPalette(assignments, assignmentMode, colorMode, paletteId, getPaletteFn, preserveColorChanges) {
  const palette = getPaletteFn(paletteId);
  const maxColors = palette.type === 'categorical' ? palette.colorCount : _container.MAX_ASSIGNABLE_COLORS;
  return assignmentMode === 'auto' ? [] : assignments.map(({
    rule,
    color,
    touched
  }, index) => {
    if (preserveColorChanges && touched) {
      return {
        rule,
        color,
        touched
      };
    } else {
      const newColor = colorMode.type === 'categorical' ? {
        type: 'categorical',
        paletteId: index < maxColors ? paletteId : _palettes.NeutralPalette.id,
        colorIndex: index < maxColors ? index : 0
      } : {
        type: 'gradient'
      };
      return {
        rule,
        color: newColor,
        touched: false
      };
    }
  });
}
function updateColorModePalette(colorMode, paletteId, preserveColorChanges) {
  return colorMode.type === 'categorical' ? colorMode : {
    type: 'gradient',
    steps: colorMode.steps.map((step, stepIndex) => {
      return preserveColorChanges ? step : {
        type: 'categorical',
        paletteId,
        colorIndex: stepIndex,
        touched: false
      };
    }),
    sort: colorMode.sort
  };
}
function getUnusedColorForNewAssignment(palette, colorMode, assignments) {
  if (colorMode.type === 'categorical') {
    // TODO: change the type of color assignment depending on palette
    // compute the next unused color index in the palette.
    const maxColors = palette.type === 'categorical' ? palette.colorCount : _container.MAX_ASSIGNABLE_COLORS;
    const colorIndices = new Set(Array.from({
      length: maxColors
    }, (d, i) => i));
    assignments.forEach(({
      color
    }) => {
      if (color.type === 'categorical' && color.paletteId === palette.id) {
        colorIndices.delete(color.colorIndex);
      }
    });
    const paletteForNextUnusedColorIndex = colorIndices.size > 0 ? palette.id : _palettes.NeutralPalette.id;
    const nextUnusedColorIndex = colorIndices.size > 0 ? [...colorIndices][0] : _default_color_mapping.DEFAULT_NEUTRAL_PALETTE_INDEX;
    return {
      type: 'categorical',
      paletteId: paletteForNextUnusedColorIndex,
      colorIndex: nextUnusedColorIndex
    };
  } else {
    return {
      type: 'gradient'
    };
  }
}