"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Gradient = Gradient;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _color_math = require("../../color/color_math");
var _color_swatch = require("../color_picker/color_swatch");
var _color_mapping = require("../../state/color_mapping");
var _ui = require("../../state/ui");
var _color_handling = require("../../color/color_handling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function Gradient({
  paletteId,
  colorMode,
  getPaletteFn,
  isDarkMode,
  assignmentsSize
}) {
  if (colorMode.type === 'categorical') {
    return null;
  }
  const currentPalette = getPaletteFn(paletteId);
  const gradientColorScale = (0, _color_handling.getGradientColorScale)(colorMode, getPaletteFn, isDarkMode);
  const topMostColorStop = colorMode.sort === 'asc' ? colorMode.steps.length === 1 ? undefined : colorMode.steps.at(-1) : colorMode.steps.at(0);
  const topMostColorStopIndex = colorMode.sort === 'asc' ? colorMode.steps.length === 1 ? NaN : colorMode.steps.length - 1 : 0;
  const bottomMostColorStop = colorMode.sort === 'asc' ? colorMode.steps.at(0) : colorMode.steps.length === 1 ? undefined : colorMode.steps.at(-1);
  const bottomMostColorStopIndex = colorMode.sort === 'asc' ? 0 : colorMode.steps.length === 1 ? NaN : colorMode.steps.length - 1;
  const middleMostColorSep = colorMode.steps.length === 3 ? colorMode.steps[1] : undefined;
  const middleMostColorStopIndex = colorMode.steps.length === 3 ? 1 : NaN;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, assignmentsSize > 1 && /*#__PURE__*/_react.default.createElement("div", {
    className: "gradientLine",
    css: (0, _react2.css)`
            position: relative;
            grid-column: 1;
            grid-row: 1;
            width: 6px;
            margin-left: 5px;
            top: 16px;
            height: calc(100% - 12px);
            border-top-left-radius: 6px;
            border-top-right-radius: 6px;
            background-image: linear-gradient(
              to bottom,
              ${[gradientColorScale(0), gradientColorScale(1 / assignmentsSize)].join(',')}
            );
            border-left: 1px solid ${(0, _color_math.changeAlpha)(_uiTheme.euiThemeVars.euiColorDarkestShade, 0.2)};
            border-top: 1px solid ${(0, _color_math.changeAlpha)(_uiTheme.euiThemeVars.euiColorDarkestShade, 0.2)};
            border-right: 1px solid ${(0, _color_math.changeAlpha)(_uiTheme.euiThemeVars.euiColorDarkestShade, 0.2)};
          `
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "gradientStop",
    css: (0, _react2.css)`
          position: relative;
          grid-column: 1;
          grid-row: 1;
          margin-top: 8px;
        `
  }, topMostColorStop ? /*#__PURE__*/_react.default.createElement(ColorStop, {
    colorMode: colorMode,
    step: topMostColorStop,
    index: topMostColorStopIndex,
    currentPalette: currentPalette,
    getPaletteFn: getPaletteFn,
    isDarkMode: isDarkMode
  }) : /*#__PURE__*/_react.default.createElement(AddStop, {
    colorMode: colorMode,
    currentPalette: currentPalette,
    at: 1
  })), assignmentsSize > 1 && /*#__PURE__*/_react.default.createElement("div", {
    className: "gradientLine",
    css: (0, _react2.css)`
            position: relative;
            z-index: 1;
            grid-column: 1;
            grid-row-start: 2;
            grid-row-end: ${assignmentsSize};
            background-image: linear-gradient(
              to bottom,
              ${[gradientColorScale(1 / assignmentsSize), gradientColorScale((assignmentsSize - 1) / assignmentsSize)].join(',')}
            );
            margin: -4px 0;
            width: 6px;
            margin-left: 5px;
            ${assignmentsSize === 2 ? 'height: 0;' : ''};
            border-left: 1px solid ${(0, _color_math.changeAlpha)(_uiTheme.euiThemeVars.euiColorDarkestShade, 0.2)};
            border-right: 1px solid ${(0, _color_math.changeAlpha)(_uiTheme.euiThemeVars.euiColorDarkestShade, 0.2)};
          `
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              position: absolute;
              width: 16px;
              height: 16px;
              top: calc(50% - 5px);
              margin-left: -6px;
              margin-top: -3px;
            `
  }, middleMostColorSep ? /*#__PURE__*/_react.default.createElement(ColorStop, {
    colorMode: colorMode,
    step: middleMostColorSep,
    index: middleMostColorStopIndex,
    currentPalette: currentPalette,
    getPaletteFn: getPaletteFn,
    isDarkMode: isDarkMode
  }) : colorMode.steps.length === 2 ? /*#__PURE__*/_react.default.createElement(AddStop, {
    colorMode: colorMode,
    currentPalette: currentPalette,
    at: 1
  }) : undefined)), assignmentsSize > 1 && /*#__PURE__*/_react.default.createElement("div", {
    className: "gradientLine",
    css: (0, _react2.css)`
            position: relative;

            grid-column: 1;
            grid-row: ${assignmentsSize};
            background-image: linear-gradient(
              to bottom,

              ${[gradientColorScale((assignmentsSize - 1) / assignmentsSize), gradientColorScale(1)].join(',')}
            );
            top: -4px;
            height: 24px;
            width: 6px;
            margin-left: 5px;
            border-bottom-left-radius: 6px;
            border-bottom-right-radius: 6px;
            border-left: 1px solid ${(0, _color_math.changeAlpha)(_uiTheme.euiThemeVars.euiColorDarkestShade, 0.2)};
            border-bottom: 1px solid ${(0, _color_math.changeAlpha)(_uiTheme.euiThemeVars.euiColorDarkestShade, 0.2)};
            border-right: 1px solid ${(0, _color_math.changeAlpha)(_uiTheme.euiThemeVars.euiColorDarkestShade, 0.2)};
          `
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          position: relative;
          grid-column: 1;
          grid-row: ${assignmentsSize};
          width: 16px;
          height: 16px;
          margin-top: 8px;
        `
  }, bottomMostColorStop ? /*#__PURE__*/_react.default.createElement(ColorStop, {
    colorMode: colorMode,
    step: bottomMostColorStop,
    index: bottomMostColorStopIndex,
    currentPalette: currentPalette,
    getPaletteFn: getPaletteFn,
    isDarkMode: isDarkMode
  }) : /*#__PURE__*/_react.default.createElement(AddStop, {
    colorMode: colorMode,
    currentPalette: currentPalette,
    at: 1
  })));
}
function AddStop({
  colorMode,
  currentPalette,
  at
}) {
  const euiTheme = (0, _eui.useEuiTheme)();
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement("button", {
    css: (0, _react2.css)`
        position: relative;
        border-radius: 50%;
        width: 17px;
        height: 17px;
        padding: 0 0.5px;
        ${(0, _eui.euiFocusRing)(euiTheme)};
      `,
    onClick: () => {
      dispatch((0, _color_mapping.addGradientColorStep)({
        color: {
          type: 'categorical',
          // TODO assign the next available color or a better one
          colorIndex: colorMode.steps.length,
          paletteId: currentPalette.id
        },
        at
      }));
      dispatch((0, _ui.colorPickerVisibility)({
        index: at,
        type: 'gradient',
        visible: true
      }));
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          width: 15px;
          height: 15px;
          border-radius: 50%;
          transition: 200ms background-color;
          background-color: lightgrey;
          &:hover {
            background-color: #696f7d;
          }
          ${(0, _eui.euiShadowSmall)(euiTheme)}
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "plus",
    css: (0, _react2.css)`
            position: absolute;
            top: 0.5px;
            left: 0;
            transition: 200ms fill;
            &:hover {
              fill: white;
            }
          `,
    color: '#696f7d'
  })));
}
function ColorStop({
  colorMode,
  step,
  index,
  currentPalette,
  getPaletteFn,
  isDarkMode
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement(_color_swatch.ColorSwatch, {
    canPickColor: true,
    colorMode: colorMode,
    assignmentColor: step,
    getPaletteFn: getPaletteFn,
    index: index,
    palette: currentPalette,
    total: colorMode.steps.length,
    swatchShape: "round",
    isDarkMode: isDarkMode,
    onColorChange: color => {
      dispatch((0, _color_mapping.updateGradientColorStep)({
        index,
        color
      }));
    },
    forType: "gradient"
  });
}