"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupSavedObjects = setupSavedObjects;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _mappings = require("./mappings");
var _migrations = require("./migrations");
var _schemas = require("../../common/schemas");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setupSavedObjects(savedObjects) {
  savedObjects.registerType({
    name: _constants.CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE,
    indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
    hidden: false,
    namespaceType: 'agnostic',
    management: {
      importableAndExportable: true,
      visibleInManagement: true
    },
    schemas: {
      '8.3.0': _schemas.cspRuleTemplateSchemaV830,
      '8.4.0': _schemas.cspRuleTemplateSchemaV840,
      '8.7.0': _schemas.cspRuleTemplateSchemaV870
    },
    migrations: _migrations.cspRuleTemplateMigrations,
    mappings: _mappings.cspRuleTemplateSavedObjectMapping
  });
}