"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilters = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const compareOptions = {
  negate: false
};

/**
 * adds a new filter to a new filters array
 * removes existing filter if negated filter is added
 *
 * @returns {Filter[]} a new array of filters to be added back to filterManager
 */
const getFilters = ({
  filters: existingFilters,
  dataView,
  field,
  value,
  negate
}) => {
  const dataViewField = dataView.fields.find(f => f.spec.name === field);
  if (!dataViewField) return existingFilters;
  const phraseFilter = (0, _esQuery.buildFilter)(dataView, dataViewField, _esQuery.FILTERS.PHRASE, negate, false, value, null, _esQuery.FilterStateStore.APP_STATE);
  const nextFilters = [...existingFilters.filter(
  // Exclude existing filters that match the newly added 'phraseFilter'
  filter => !(0, _esQuery.compareFilters)(filter, phraseFilter, compareOptions)), phraseFilter];
  return nextFilters;
};
exports.getFilters = getFilters;