"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLatestVulnerabilities = exports.getFindingsQuery = void 0;
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _ioTs = require("io-ts");
var _constants = require("../../../../common/constants");
var _use_kibana = require("../../../common/hooks/use_kibana");
var _show_error_toast = require("../../../common/utils/show_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFindingsQuery = ({
  query,
  sort,
  pageIndex,
  pageSize
}) => ({
  index: _constants.LATEST_VULNERABILITIES_INDEX_PATTERN,
  query,
  from: pageIndex * pageSize,
  size: pageSize,
  sort
});
exports.getFindingsQuery = getFindingsQuery;
const useLatestVulnerabilities = options => {
  const {
    data,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)([_constants.LATEST_VULNERABILITIES_INDEX_PATTERN, options], async () => {
    const {
      rawResponse: {
        hits
      }
    } = await (0, _rxjs.lastValueFrom)(data.search.search({
      params: getFindingsQuery(options)
    }));
    return {
      page: hits.hits.map(hit => hit._source),
      total: _ioTs.number.is(hits.total) ? hits.total : 0
    };
  }, {
    staleTime: 5000,
    keepPreviousData: true,
    enabled: options.enabled,
    onError: err => (0, _show_error_toast.showErrorToast)(toasts, err)
  });
};
exports.useLatestVulnerabilities = useLatestVulnerabilities;