"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Rules = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/fleet-plugin/public");
var _i18n = require("@kbn/i18n");
var _csp_inline_description_list = require("../../components/csp_inline_description_list");
var _cloud_posture_page_title = require("../../components/cloud_posture_page_title");
var _rules_container = require("./rules_container");
var _constants = require("../../common/navigation/constants");
var _use_csp_integration = require("./use_csp_integration");
var _use_kibana = require("../../common/hooks/use_kibana");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _security_solution_context = require("../../application/security_solution_context");
var TEST_SUBJECTS = _interopRequireWildcard(require("./test_subjects"));
var _get_enabled_csp_integration_details = require("../../common/utils/get_enabled_csp_integration_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRulesSharedValues = packageInfo => {
  var _enabledIntegration$i;
  const enabledIntegration = (0, _get_enabled_csp_integration_details.getEnabledCspIntegrationDetails)(packageInfo);
  const values = [];
  if (enabledIntegration !== null && enabledIntegration !== void 0 && (_enabledIntegration$i = enabledIntegration.integration) !== null && _enabledIntegration$i !== void 0 && _enabledIntegration$i.shortName) {
    values.push({
      title: _i18n.i18n.translate('xpack.csp.rules.rulesPageSharedValues.integrationTitle', {
        defaultMessage: 'Integration'
      }),
      description: enabledIntegration === null || enabledIntegration === void 0 ? void 0 : enabledIntegration.integration.shortName
    });
  }
  if (!(enabledIntegration !== null && enabledIntegration !== void 0 && enabledIntegration.enabledIntegrationOption)) return values;
  values.push({
    title: _i18n.i18n.translate('xpack.csp.rules.rulesPageSharedValues.deploymentTypeTitle', {
      defaultMessage: 'Deployment Type'
    }),
    description: enabledIntegration === null || enabledIntegration === void 0 ? void 0 : enabledIntegration.enabledIntegrationOption.name
  }, {
    title: _i18n.i18n.translate('xpack.csp.rules.rulesPageSharedValues.benchmarkTitle', {
      defaultMessage: 'Benchmark'
    }),
    description: enabledIntegration === null || enabledIntegration === void 0 ? void 0 : enabledIntegration.enabledIntegrationOption.benchmark
  });
  return values;
};
const Rules = ({
  match: {
    params
  }
}) => {
  var _useSecuritySolutionC;
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const integrationInfo = (0, _use_csp_integration.useCspIntegrationInfo)(params);
  const SpyRoute = (_useSecuritySolutionC = (0, _security_solution_context.useSecuritySolutionContext)()) === null || _useSecuritySolutionC === void 0 ? void 0 : _useSecuritySolutionC.getSpyRouteComponent();
  const [packageInfo] = integrationInfo.data || [];
  const sharedValues = getRulesSharedValues(packageInfo);
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: integrationInfo
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    alignItems: 'bottom',
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        width: 'fit-content'
      }
    }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Link, {
      to: (0, _reactRouterDom.generatePath)(_constants.cloudPosturePages.benchmarks.path)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "arrowLeft",
      contentProps: {
        style: {
          padding: 0
        }
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.rules.rulesPageHeader.benchmarkRulesButtonLabel",
      defaultMessage: "Benchmark Rules"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cloud_posture_page_title.CloudPosturePageTitle, {
      title: _i18n.i18n.translate('xpack.csp.rules.rulePageHeader.pageHeaderTitle', {
        defaultMessage: 'Rules - {integrationName}',
        values: {
          integrationName: packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name
        }
      })
    }))),
    description: sharedValues.length && /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": TEST_SUBJECTS.CSP_RULES_SHARED_VALUES
    }, /*#__PURE__*/_react.default.createElement(_csp_inline_description_list.CspInlineDescriptionList, {
      listItems: sharedValues
    })),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "gear",
      size: "xs",
      href: http.basePath.prepend(_public.pagePathGetters.edit_integration(params).join(''))
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.rules.manageIntegrationButtonLabel",
      defaultMessage: "Manage Integration"
    }))]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_rules_container.RulesContainer, null), SpyRoute && /*#__PURE__*/_react.default.createElement(SpyRoute, {
    pageName: _constants.cloudPosturePages.benchmarks.id,
    state: {
      ruleName: packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name
    }
  }));
};
exports.Rules = Rules;