"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLatestFindingsGrouping = exports.isFindingsRootGroupingAggregation = void 0;
var _securitysolutionGrouping = require("@kbn/securitysolution-grouping");
var _src = require("@kbn/securitysolution-grouping/src");
var _react = require("react");
var _constants = require("../../../../common/constants");
var _use_grouped_findings = require("./use_grouped_findings");
var _constants2 = require("./constants");
var _cloud_security_grouping = require("../../../components/cloud_security_grouping");
var _get_filters = require("../utils/get_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTermAggregation = (key, field) => ({
  [key]: {
    terms: {
      field,
      size: 1
    }
  }
});
const getAggregationsByGroupField = field => {
  if ((0, _src.isNoneGroup)([field])) {
    return [];
  }
  const aggMetrics = [{
    groupByField: {
      cardinality: {
        field
      }
    },
    failedFindings: {
      filter: {
        term: {
          'result.evaluation': {
            value: 'failed'
          }
        }
      }
    },
    passedFindings: {
      filter: {
        term: {
          'result.evaluation': {
            value: 'passed'
          }
        }
      }
    },
    complianceScore: {
      bucket_script: {
        buckets_path: {
          passed: 'passedFindings>_count',
          failed: 'failedFindings>_count'
        },
        script: 'params.passed / (params.passed + params.failed)'
      }
    }
  }];
  switch (field) {
    case _constants2.GROUPING_OPTIONS.RESOURCE_NAME:
      return [...aggMetrics, getTermAggregation('resourceName', 'resource.id'), getTermAggregation('resourceSubType', 'resource.sub_type'), getTermAggregation('resourceType', 'resource.type')];
    case _constants2.GROUPING_OPTIONS.RULE_NAME:
      return [...aggMetrics, getTermAggregation('benchmarkName', 'rule.benchmark.name'), getTermAggregation('benchmarkVersion', 'rule.benchmark.version')];
    case _constants2.GROUPING_OPTIONS.CLOUD_ACCOUNT_NAME:
      return [...aggMetrics, getTermAggregation('benchmarkName', 'rule.benchmark.name'), getTermAggregation('benchmarkId', 'rule.benchmark.id')];
    case _constants2.GROUPING_OPTIONS.ORCHESTRATOR_CLUSTER_NAME:
      return [...aggMetrics, getTermAggregation('benchmarkName', 'rule.benchmark.name'), getTermAggregation('benchmarkId', 'rule.benchmark.id')];
  }
  return aggMetrics;
};

/**
 * Type Guard for checking if the given source is a FindingsRootGroupingAggregation
 */
const isFindingsRootGroupingAggregation = groupData => {
  var _groupData$passedFind, _groupData$failedFind;
  return (groupData === null || groupData === void 0 ? void 0 : (_groupData$passedFind = groupData.passedFindings) === null || _groupData$passedFind === void 0 ? void 0 : _groupData$passedFind.doc_count) !== undefined && (groupData === null || groupData === void 0 ? void 0 : (_groupData$failedFind = groupData.failedFindings) === null || _groupData$failedFind === void 0 ? void 0 : _groupData$failedFind.doc_count) !== undefined;
};

/**
 * Utility hook to get the latest findings grouping data
 * for the findings page
 */
exports.isFindingsRootGroupingAggregation = isFindingsRootGroupingAggregation;
const useLatestFindingsGrouping = ({
  dataView,
  groupPanelRenderer,
  groupStatsRenderer
}) => {
  var _groupData$passedFind2, _groupData$failedFind2, _groupData$unitsCount;
  const {
    activePageIndex,
    grouping,
    pageSize,
    query,
    selectedGroup,
    onChangeGroupsItemsPerPage,
    onChangeGroupsPage,
    setUrlQuery,
    uniqueValue,
    isNoneSelected,
    onResetFilters,
    error,
    filters
  } = (0, _cloud_security_grouping.useCloudSecurityGrouping)({
    dataView,
    groupingTitle: _constants2.groupingTitle,
    defaultGroupingOptions: _constants2.defaultGroupingOptions,
    getDefaultQuery: _constants2.getDefaultQuery,
    unit: _constants2.FINDINGS_UNIT,
    groupPanelRenderer,
    groupStatsRenderer
  });
  const groupingQuery = (0, _securitysolutionGrouping.getGroupingQuery)({
    additionalFilters: query ? [query] : [],
    groupByField: selectedGroup,
    uniqueValue,
    from: `now-${_constants.LATEST_FINDINGS_RETENTION_POLICY}`,
    to: 'now',
    pageNumber: activePageIndex * pageSize,
    size: pageSize,
    sort: [{
      groupByField: {
        order: 'desc'
      }
    }, {
      complianceScore: {
        order: 'asc'
      }
    }],
    statsAggregations: getAggregationsByGroupField(selectedGroup),
    rootAggregations: [{
      failedFindings: {
        filter: {
          term: {
            'result.evaluation': {
              value: 'failed'
            }
          }
        }
      },
      passedFindings: {
        filter: {
          term: {
            'result.evaluation': {
              value: 'passed'
            }
          }
        }
      }
    }]
  });
  const {
    data,
    isFetching
  } = (0, _use_grouped_findings.useGroupedFindings)({
    query: groupingQuery,
    enabled: !isNoneSelected
  });
  const groupData = (0, _react.useMemo)(() => (0, _src.parseGroupingQuery)(selectedGroup, uniqueValue, data), [data, selectedGroup, uniqueValue]);
  const totalPassedFindings = isFindingsRootGroupingAggregation(groupData) ? (groupData === null || groupData === void 0 ? void 0 : (_groupData$passedFind2 = groupData.passedFindings) === null || _groupData$passedFind2 === void 0 ? void 0 : _groupData$passedFind2.doc_count) || 0 : 0;
  const totalFailedFindings = isFindingsRootGroupingAggregation(groupData) ? (groupData === null || groupData === void 0 ? void 0 : (_groupData$failedFind2 = groupData.failedFindings) === null || _groupData$failedFind2 === void 0 ? void 0 : _groupData$failedFind2.doc_count) || 0 : 0;
  const onDistributionBarClick = evaluation => {
    setUrlQuery({
      filters: (0, _get_filters.getFilters)({
        filters,
        dataView,
        field: 'result.evaluation',
        value: evaluation,
        negate: false
      })
    });
  };
  const isEmptyResults = !isFetching && isFindingsRootGroupingAggregation(groupData) && !((_groupData$unitsCount = groupData.unitsCount) !== null && _groupData$unitsCount !== void 0 && _groupData$unitsCount.value);
  return {
    groupData,
    grouping,
    isFetching,
    activePageIndex,
    pageSize,
    selectedGroup,
    onChangeGroupsItemsPerPage,
    onChangeGroupsPage,
    setUrlQuery,
    isGroupSelected: !isNoneSelected,
    isGroupLoading: !data,
    onResetFilters,
    filters,
    error,
    onDistributionBarClick,
    totalPassedFindings,
    totalFailedFindings,
    isEmptyResults
  };
};
exports.useLatestFindingsGrouping = useLatestFindingsGrouping;