"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.firstNonNullValue = firstNonNullValue;
exports.groupStatsRenderer = exports.groupPanelRenderer = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _get_abbreviated_number = require("../../../common/utils/get_abbreviated_number");
var _cis_benchmark_icon = require("../../../components/cis_benchmark_icon");
var _compliance_score_bar = require("../../../components/compliance_score_bar");
var _constants = require("./constants");
var _test_subjects = require("../test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return first non-null value. If the field contains an array, this will return the first value that isn't null. If the field isn't an array it'll be returned unless it's null.
 */
function firstNonNullValue(valueOrCollection) {
  if (valueOrCollection === null) {
    return undefined;
  } else if (Array.isArray(valueOrCollection)) {
    for (const value of valueOrCollection) {
      if (value !== null) {
        return value;
      }
    }
  } else {
    return valueOrCollection;
  }
}
const NullGroupComponent = ({
  title,
  field,
  unit = _constants.NULL_GROUPING_UNIT
}) => {
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement("strong", null, title), /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    anchorProps: {
      css: (0, _react.css)`
            display: inline-flex;
          `
    },
    content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.findings.grouping.nullGroupTooltip",
      defaultMessage: "The selected {groupingTitle} field, {field} is missing a value for this group of {unit}.",
      values: {
        groupingTitle: /*#__PURE__*/_react2.default.createElement("strong", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.findings.grouping.nullGroupTooltip.groupingTitle",
          defaultMessage: "group by"
        })),
        field: /*#__PURE__*/_react2.default.createElement("code", null, field),
        unit
      }
    })),
    position: "right"
  }));
};
const groupPanelRenderer = (selectedGroup, bucket, nullGroupMessage, isLoading) => {
  var _bucket$benchmarkId, _bucket$benchmarkId$b, _bucket$benchmarkId$b2, _bucket$resourceName, _bucket$resourceName$, _bucket$resourceName2, _bucket$resourceName3, _bucket$resourceSubTy, _bucket$resourceSubTy2, _bucket$benchmarkName, _bucket$benchmarkName2, _bucket$benchmarkVers, _bucket$benchmarkVers2, _bucket$benchmarkName3, _bucket$benchmarkName4, _bucket$benchmarkName5, _bucket$benchmarkName6, _bucket$benchmarkName7, _bucket$benchmarkName8, _bucket$benchmarkName9, _bucket$benchmarkName10, _bucket$benchmarkName11, _bucket$benchmarkName12, _bucket$benchmarkName13, _bucket$benchmarkName14;
  if (isLoading) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonTitle, {
      size: "s",
      isLoading: true
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.findings.grouping.loadingGroupPanelTitle",
      defaultMessage: "Loading"
    }));
  }
  const benchmarkId = firstNonNullValue((_bucket$benchmarkId = bucket.benchmarkId) === null || _bucket$benchmarkId === void 0 ? void 0 : (_bucket$benchmarkId$b = _bucket$benchmarkId.buckets) === null || _bucket$benchmarkId$b === void 0 ? void 0 : (_bucket$benchmarkId$b2 = _bucket$benchmarkId$b[0]) === null || _bucket$benchmarkId$b2 === void 0 ? void 0 : _bucket$benchmarkId$b2.key);
  switch (selectedGroup) {
    case _constants.GROUPING_OPTIONS.RESOURCE_NAME:
      return nullGroupMessage ? /*#__PURE__*/_react2.default.createElement(NullGroupComponent, {
        title: _constants.NULL_GROUPING_MESSAGES.RESOURCE_NAME,
        field: selectedGroup
      }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        css: (0, _react.css)`
                  display: inline;
                `
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextBlockTruncate, {
        lines: 2,
        css: (0, _react.css)`
                      word-break: break-all;
                    `,
        title: (_bucket$resourceName = bucket.resourceName) === null || _bucket$resourceName === void 0 ? void 0 : (_bucket$resourceName$ = _bucket$resourceName.buckets) === null || _bucket$resourceName$ === void 0 ? void 0 : _bucket$resourceName$[0].key
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string), " ", (_bucket$resourceName2 = bucket.resourceName) === null || _bucket$resourceName2 === void 0 ? void 0 : (_bucket$resourceName3 = _bucket$resourceName2.buckets) === null || _bucket$resourceName3 === void 0 ? void 0 : _bucket$resourceName3[0].key))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, (_bucket$resourceSubTy = bucket.resourceSubType) === null || _bucket$resourceSubTy === void 0 ? void 0 : (_bucket$resourceSubTy2 = _bucket$resourceSubTy.buckets) === null || _bucket$resourceSubTy2 === void 0 ? void 0 : _bucket$resourceSubTy2[0].key)))));
    case _constants.GROUPING_OPTIONS.RULE_NAME:
      return nullGroupMessage ? /*#__PURE__*/_react2.default.createElement(NullGroupComponent, {
        title: _constants.NULL_GROUPING_MESSAGES.RULE_NAME,
        field: selectedGroup
      }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, firstNonNullValue((_bucket$benchmarkName = bucket.benchmarkName) === null || _bucket$benchmarkName === void 0 ? void 0 : (_bucket$benchmarkName2 = _bucket$benchmarkName.buckets) === null || _bucket$benchmarkName2 === void 0 ? void 0 : _bucket$benchmarkName2[0].key), ' ', firstNonNullValue((_bucket$benchmarkVers = bucket.benchmarkVersion) === null || _bucket$benchmarkVers === void 0 ? void 0 : (_bucket$benchmarkVers2 = _bucket$benchmarkVers.buckets) === null || _bucket$benchmarkVers2 === void 0 ? void 0 : _bucket$benchmarkVers2[0].key))))));
    case _constants.GROUPING_OPTIONS.CLOUD_ACCOUNT_NAME:
      return nullGroupMessage ? /*#__PURE__*/_react2.default.createElement(NullGroupComponent, {
        title: _constants.NULL_GROUPING_MESSAGES.CLOUD_ACCOUNT_NAME,
        field: selectedGroup
      }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "m"
      }, benchmarkId && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: 0
      }, /*#__PURE__*/_react2.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
        type: benchmarkId,
        name: firstNonNullValue((_bucket$benchmarkName3 = bucket.benchmarkName) === null || _bucket$benchmarkName3 === void 0 ? void 0 : (_bucket$benchmarkName4 = _bucket$benchmarkName3.buckets) === null || _bucket$benchmarkName4 === void 0 ? void 0 : (_bucket$benchmarkName5 = _bucket$benchmarkName4[0]) === null || _bucket$benchmarkName5 === void 0 ? void 0 : _bucket$benchmarkName5.key)
      })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, (_bucket$benchmarkName6 = bucket.benchmarkName) === null || _bucket$benchmarkName6 === void 0 ? void 0 : (_bucket$benchmarkName7 = _bucket$benchmarkName6.buckets) === null || _bucket$benchmarkName7 === void 0 ? void 0 : (_bucket$benchmarkName8 = _bucket$benchmarkName7[0]) === null || _bucket$benchmarkName8 === void 0 ? void 0 : _bucket$benchmarkName8.key)))));
    case _constants.GROUPING_OPTIONS.ORCHESTRATOR_CLUSTER_NAME:
      return nullGroupMessage ? /*#__PURE__*/_react2.default.createElement(NullGroupComponent, {
        title: _constants.NULL_GROUPING_MESSAGES.ORCHESTRATOR_CLUSTER_NAME,
        field: selectedGroup
      }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "m"
      }, benchmarkId && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: 0
      }, /*#__PURE__*/_react2.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
        type: benchmarkId,
        name: firstNonNullValue((_bucket$benchmarkName9 = bucket.benchmarkName) === null || _bucket$benchmarkName9 === void 0 ? void 0 : (_bucket$benchmarkName10 = _bucket$benchmarkName9.buckets) === null || _bucket$benchmarkName10 === void 0 ? void 0 : (_bucket$benchmarkName11 = _bucket$benchmarkName10[0]) === null || _bucket$benchmarkName11 === void 0 ? void 0 : _bucket$benchmarkName11.key)
      })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, (_bucket$benchmarkName12 = bucket.benchmarkName) === null || _bucket$benchmarkName12 === void 0 ? void 0 : (_bucket$benchmarkName13 = _bucket$benchmarkName12.buckets) === null || _bucket$benchmarkName13 === void 0 ? void 0 : (_bucket$benchmarkName14 = _bucket$benchmarkName13[0]) === null || _bucket$benchmarkName14 === void 0 ? void 0 : _bucket$benchmarkName14.key)))));
    default:
      return nullGroupMessage ? /*#__PURE__*/_react2.default.createElement(NullGroupComponent, {
        title: _constants.NULL_GROUPING_MESSAGES.DEFAULT,
        field: selectedGroup
      }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string))))));
  }
};
exports.groupPanelRenderer = groupPanelRenderer;
const FindingsCountComponent = ({
  bucket
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: bucket.doc_count
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    css: (0, _react.css)`
          margin-left: ${euiTheme.size.s}};
        `,
    color: "hollow",
    "data-test-subj": _test_subjects.FINDINGS_GROUPING_COUNTER
  }, (0, _get_abbreviated_number.getAbbreviatedNumber)(bucket.doc_count)));
};
const FindingsCount = /*#__PURE__*/_react2.default.memo(FindingsCountComponent);
const ComplianceBarComponent = ({
  bucket
}) => {
  var _bucket$failedFinding;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const totalFailed = ((_bucket$failedFinding = bucket.failedFindings) === null || _bucket$failedFinding === void 0 ? void 0 : _bucket$failedFinding.doc_count) || 0;
  const totalPassed = bucket.doc_count - totalFailed;
  return /*#__PURE__*/_react2.default.createElement(_compliance_score_bar.ComplianceScoreBar, {
    size: "l",
    overrideCss: (0, _react.css)`
        width: 104px;
        margin-left: ${euiTheme.size.s}};
      `,
    totalFailed: totalFailed,
    totalPassed: totalPassed
  });
};
const ComplianceBar = /*#__PURE__*/_react2.default.memo(ComplianceBarComponent);
const groupStatsRenderer = (selectedGroup, bucket) => {
  const defaultBadges = [{
    title: _i18n.i18n.translate('xpack.csp.findings.grouping.stats.badges.findings', {
      defaultMessage: 'Findings'
    }),
    renderer: /*#__PURE__*/_react2.default.createElement(FindingsCount, {
      bucket: bucket
    })
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.grouping.stats.badges.compliance', {
      defaultMessage: 'Compliance'
    }),
    renderer: /*#__PURE__*/_react2.default.createElement(ComplianceBar, {
      bucket: bucket
    })
  }];
  return defaultBadges;
};
exports.groupStatsRenderer = groupStatsRenderer;