"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatestFindingsContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _empty_state = require("../../../components/empty_state");
var _cloud_security_grouping = require("../../../components/cloud_security_grouping");
var _findings_search_bar = require("../layout/findings_search_bar");
var _constants = require("./constants");
var _use_latest_findings_grouping = require("./use_latest_findings_grouping");
var _latest_findings_table = require("./latest_findings_table");
var _latest_findings_group_renderer = require("./latest_findings_group_renderer");
var _findings_distribution_bar = require("../layout/findings_distribution_bar");
var _error_callout = require("../layout/error_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LatestFindingsContainer = ({
  dataView
}) => {
  const renderChildComponent = (0, _react.useCallback)(groupFilters => {
    return /*#__PURE__*/_react.default.createElement(_latest_findings_table.LatestFindingsTable, {
      dataView: dataView,
      nonPersistedFilters: groupFilters,
      height: _constants.DEFAULT_TABLE_HEIGHT,
      showDistributionBar: false
    });
  }, [dataView]);
  const {
    isGroupSelected,
    groupData,
    grouping,
    isFetching,
    activePageIndex,
    pageSize,
    selectedGroup,
    onChangeGroupsItemsPerPage,
    onChangeGroupsPage,
    setUrlQuery,
    isGroupLoading,
    onResetFilters,
    error,
    totalPassedFindings,
    onDistributionBarClick,
    totalFailedFindings,
    isEmptyResults
  } = (0, _use_latest_findings_grouping.useLatestFindingsGrouping)({
    dataView,
    groupPanelRenderer: _latest_findings_group_renderer.groupPanelRenderer,
    groupStatsRenderer: _latest_findings_group_renderer.groupStatsRenderer
  });
  if (error || isEmptyResults) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_findings_search_bar.FindingsSearchBar, {
      dataView: dataView,
      setQuery: setUrlQuery,
      loading: isFetching
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), error && /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
      error: error
    }), isEmptyResults && /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, {
      onResetFilters: onResetFilters
    }));
  }
  if (isGroupSelected) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_findings_search_bar.FindingsSearchBar, {
      dataView: dataView,
      setQuery: setUrlQuery,
      loading: isFetching
    }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_findings_distribution_bar.FindingsDistributionBar, {
      distributionOnClick: onDistributionBarClick,
      passed: totalPassedFindings,
      failed: totalFailedFindings
    }), /*#__PURE__*/_react.default.createElement(_cloud_security_grouping.CloudSecurityGrouping, {
      data: groupData,
      grouping: grouping,
      renderChildComponent: renderChildComponent,
      onChangeGroupsItemsPerPage: onChangeGroupsItemsPerPage,
      onChangeGroupsPage: onChangeGroupsPage,
      activePageIndex: activePageIndex,
      isFetching: isFetching,
      pageSize: pageSize,
      selectedGroup: selectedGroup,
      isGroupLoading: isGroupLoading
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_findings_search_bar.FindingsSearchBar, {
    dataView: dataView,
    setQuery: setUrlQuery,
    loading: isFetching
  }), /*#__PURE__*/_react.default.createElement(_latest_findings_table.LatestFindingsTable, {
    dataView: dataView,
    groupSelectorComponent: grouping.groupSelector
  }));
};
exports.LatestFindingsContainer = LatestFindingsContainer;