"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityStatusBadge = exports.CVSScoreBadge = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _get_vulnerability_colors = require("../common/utils/get_vulnerability_colors");
var _test_subjects = require("./test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CVSScoreBadge = ({
  score,
  version
}) => {
  const color = (0, _get_vulnerability_colors.getCvsScoreColor)(score);
  const versionDisplay = version ? `v${version.split('.')[0]}` : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color,
    css: (0, _react2.css)`
        border: none;
        .euiBadge__text {
          display: flex;
        }
        width: 62px;
      `,
    "data-test-subj": _test_subjects.VULNERABILITIES_CVSS_SCORE_BADGE_SUBJ
  }, versionDisplay && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "ghost"
  }, score < 10 ? score.toFixed(1) : score), /*#__PURE__*/_react.default.createElement("hr", {
    css: (0, _react2.css)`
              width: 1px;
              border: 0 none;
              background-color: rgba(255, 255, 255, 0.2);
              margin: 0px 6px;
            `
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "ghost"
  }, versionDisplay)));
};
exports.CVSScoreBadge = CVSScoreBadge;
const SeverityStatusBadge = ({
  severity
}) => {
  const color = (0, _get_vulnerability_colors.getSeverityStatusColor)(severity);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        display: flex;
        flex-direction: row;
        align-items: center;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "dot",
    color: color,
    css: (0, _react2.css)`
          opacity: ${severity ? 1 : 0};
        `
  }), severity);
};
exports.SeverityStatusBadge = SeverityStatusBadge;