"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspCounterCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CspCounterCard = ({
  id,
  button,
  title,
  titleColor,
  description
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "m",
    "data-test-subj": id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    css: {
      height: '60%',
      display: 'flex',
      flexDirection: 'column',
      justifyContent: 'space-around',
      '.euiText h6': {
        textTransform: 'capitalize',
        fontSize: euiTheme.size.m
      }
    },
    titleSize: "s",
    title: title,
    titleColor: titleColor,
    descriptionElement: "h6",
    description: description
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), button);
};
exports.CspCounterCard = CspCounterCard;