"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComplianceScoreBar = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _helpers = require("../../common/utils/helpers");
var _constants = require("../common/constants");
var _test_subjects = require("./test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component will take 100% of the width set by the parent
 * */
const ComplianceScoreBar = ({
  totalPassed,
  totalFailed,
  size = 'm',
  overrideCss
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const complianceScore = (0, _helpers.calculatePostureScore)(totalPassed, totalFailed);

  // ensures the compliance bar takes full width of its parent
  const fullWidthTooltipCss = (0, _react.css)`
    width: 100%;
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    anchorProps: {
      css: overrideCss || fullWidthTooltipCss
    },
    content: _i18n.i18n.translate('xpack.csp.complianceScoreBar.tooltipTitle', {
      defaultMessage: '{failed} failed and {passed} passed findings',
      values: {
        passed: totalPassed,
        failed: totalFailed
      }
    })
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: (0, _react.css)`
              height: ${size === 'm' ? euiTheme.size.xs : '6px'};
              border-radius: ${euiTheme.border.radius.medium};
              overflow: hidden;
              gap: 1px;
            `
  }, !!totalPassed && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
                  flex: ${totalPassed};
                  background: ${_constants.statusColors.passed};
                `
  }), !!totalFailed && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
                  flex: ${totalFailed};
                  background: ${_constants.statusColors.failed};
                `
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
            width: ${euiTheme.size.xxl};
            text-align: right;
          `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": _test_subjects.CSP_FINDINGS_COMPLIANCE_SCORE,
    css: (0, _react.css)`
              font-weight: ${euiTheme.font.weight.bold};
            `
  }, `${complianceScore.toFixed(0)}%`))));
};
exports.ComplianceScoreBar = ComplianceScoreBar;