"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountsEvaluatedWidget = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("../../common/constants");
var _cis_benchmark_icon = require("./cis_benchmark_icon");
var _compact_formatted_number = require("./compact_formatted_number");
var _use_navigate_findings = require("../common/hooks/use_navigate_findings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// order in array will determine order of appearance in the dashboard
const benchmarks = [{
  type: _constants.CIS_AWS,
  name: 'Amazon Web Services (AWS)',
  provider: 'aws'
}, {
  type: _constants.CIS_GCP,
  name: 'Google Cloud Platform (GCP)',
  provider: 'gcp'
}, {
  type: _constants.CIS_AZURE,
  name: 'Azure',
  provider: 'azure'
}, {
  type: _constants.CIS_K8S,
  name: 'Kubernetes',
  benchmarkId: 'cis_k8s'
}, {
  type: _constants.CIS_EKS,
  name: 'Amazon Elastic Kubernetes Service (EKS)',
  benchmarkId: 'cis_eks'
}];
const AccountsEvaluatedWidget = ({
  benchmarkAssets,
  benchmarkAbbreviateAbove = 999
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const getBenchmarkById = benchmarkId => {
    return benchmarkAssets === null || benchmarkAssets === void 0 ? void 0 : benchmarkAssets.find(obj => (obj === null || obj === void 0 ? void 0 : obj.meta.benchmarkId) === benchmarkId);
  };
  const navToFindings = (0, _use_navigate_findings.useNavigateFindings)();
  const navToFindingsByCloudProvider = provider => {
    navToFindings({
      'cloud.provider': provider
    });
  };
  const navToFindingsByCisBenchmark = cisBenchmark => {
    navToFindings({
      'rule.benchmark.id': cisBenchmark
    });
  };
  const benchmarkElements = benchmarks.map(benchmark => {
    var _getBenchmarkById, _getBenchmarkById$met;
    const cloudAssetAmount = ((_getBenchmarkById = getBenchmarkById(benchmark.type)) === null || _getBenchmarkById === void 0 ? void 0 : (_getBenchmarkById$met = _getBenchmarkById.meta) === null || _getBenchmarkById$met === void 0 ? void 0 : _getBenchmarkById$met.assetCount) || 0;
    return cloudAssetAmount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: benchmark.type,
      onClick: () => {
        if (benchmark.provider) {
          navToFindingsByCloudProvider(benchmark.provider);
        }
        if (benchmark.benchmarkId) {
          navToFindingsByCisBenchmark(benchmark.benchmarkId);
        }
      },
      css: (0, _react2.css)`
            transition: ${euiTheme.animation.normal} ease-in;
            border-bottom: ${euiTheme.border.thick};
            border-color: transparent;
            text-wrap: nowrap;
            :hover {
              cursor: pointer;
              border-color: ${euiTheme.colors.darkestShade};
            }
          `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
      type: benchmark.type,
      name: benchmark.name,
      size: 'l'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
      number: cloudAssetAmount,
      abbreviateAbove: benchmarkAbbreviateAbove
    }))));
  });

  // Render the benchmark elements
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, benchmarkElements);
};
exports.AccountsEvaluatedWidget = AccountsEvaluatedWidget;