"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloudPostureTable = void 0;
var _react = require("react");
var _use_url_query = require("../use_url_query");
var _use_page_size = require("../use_page_size");
var _utils = require("./utils");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
  Hook for managing common table state and methods for Cloud Posture
*/
const useCloudPostureTable = ({
  defaultQuery = _utils.getDefaultQuery,
  dataView,
  paginationLocalStorageKey,
  columnsLocalStorageKey
}) => {
  const getPersistedDefaultQuery = (0, _utils.usePersistedQuery)(defaultQuery);
  const {
    urlQuery,
    setUrlQuery
  } = (0, _use_url_query.useUrlQuery)(getPersistedDefaultQuery);
  const {
    pageSize,
    setPageSize
  } = (0, _use_page_size.usePageSize)(paginationLocalStorageKey);
  const onChangeItemsPerPage = (0, _react.useCallback)(newPageSize => {
    setPageSize(newPageSize);
    setUrlQuery({
      pageIndex: 0,
      pageSize: newPageSize
    });
  }, [setPageSize, setUrlQuery]);
  const onResetFilters = (0, _react.useCallback)(() => {
    setUrlQuery({
      pageIndex: 0,
      filters: [],
      query: {
        query: '',
        language: 'kuery'
      }
    });
  }, [setUrlQuery]);
  const onChangePage = (0, _react.useCallback)(newPageIndex => {
    setUrlQuery({
      pageIndex: newPageIndex
    });
  }, [setUrlQuery]);
  const onSort = (0, _react.useCallback)(sort => {
    setUrlQuery({
      sort
    });
  }, [setUrlQuery]);
  const setTableOptions = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    setPageSize(page.size);
    setUrlQuery({
      sort,
      pageIndex: page.index
    });
  }, [setUrlQuery, setPageSize]);

  /**
   * Page URL query to ES query
   */
  const baseEsQuery = (0, _utils.useBaseEsQuery)({
    dataView,
    filters: urlQuery.filters,
    query: urlQuery.query
  });
  const handleUpdateQuery = (0, _react.useCallback)(query => {
    setUrlQuery({
      ...query,
      pageIndex: 0
    });
  }, [setUrlQuery]);
  const getRowsFromPages = data => (data === null || data === void 0 ? void 0 : data.map(({
    page
  }) => {
    return page;
  }).flat()) || [];
  return {
    setUrlQuery,
    sort: urlQuery.sort,
    filters: urlQuery.filters,
    query: baseEsQuery.query,
    queryError: baseEsQuery.error,
    pageIndex: urlQuery.pageIndex,
    urlQuery,
    setTableOptions,
    handleUpdateQuery,
    pageSize,
    setPageSize,
    onChangeItemsPerPage,
    onChangePage,
    onSort,
    onResetFilters,
    columnsLocalStorageKey: columnsLocalStorageKey || _constants.LOCAL_STORAGE_DATA_TABLE_COLUMNS_KEY,
    getRowsFromPages
  };
};
exports.useCloudPostureTable = useCloudPostureTable;