"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VULN_MGMT_POLICY_TEMPLATE = exports.VULNERABILITIES_SEVERITY = exports.VULNERABILITIES_INDEX_PATTERN = exports.VULNERABILITIES_INDEX_NAME = exports.VULNERABILITIES_INDEX_DEFAULT_NS = exports.VULNERABILITIES_ENUMERATION = exports.VULNERABILITIES_DASHBOARD_ROUTE_PATH = exports.VULNERABILITIES = exports.SUPPORTED_POLICY_TEMPLATES = exports.SUPPORTED_CLOUDBEAT_INPUTS = exports.STATUS_ROUTE_PATH = exports.STATUS_API_CURRENT_VERSION = exports.STATS_ROUTE_PATH = exports.SETUP_ACCESS_MANUAL = exports.SETUP_ACCESS_CLOUD_SHELL = exports.SECURITY_DEFAULT_DATA_VIEW_ID = exports.RULE_PASSED = exports.RULE_FAILED = exports.POSTURE_TYPE_ALL = exports.POSTURE_TYPES = exports.LATEST_VULNERABILITIES_RETENTION_POLICY = exports.LATEST_VULNERABILITIES_INDEX_TEMPLATE_NAME = exports.LATEST_VULNERABILITIES_INDEX_PATTERN = exports.LATEST_VULNERABILITIES_INDEX_DEFAULT_NS = exports.LATEST_FINDINGS_RETENTION_POLICY = exports.LATEST_FINDINGS_INDEX_TEMPLATE_NAME = exports.LATEST_FINDINGS_INDEX_PATTERN = exports.LATEST_FINDINGS_INDEX_DEFAULT_NS = exports.KSPM_POLICY_TEMPLATE = exports.INTERNAL_FEATURE_FLAGS = exports.GET_DETECTION_RULE_ALERTS_STATUS_PATH = exports.GCP_CREDENTIALS_TYPE_TO_FIELDS_MAP = exports.FIND_CSP_RULE_TEMPLATE_ROUTE_PATH = exports.FIND_CSP_RULE_TEMPLATE_API_CURRENT_VERSION = exports.FINDINGS_INDEX_PATTERN = exports.FINDINGS_INDEX_NAME = exports.FINDINGS_INDEX_DEFAULT_NS = exports.DETECTION_RULE_RULES_API_CURRENT_VERSION = exports.DETECTION_RULE_ALERTS_STATUS_API_CURRENT_VERSION = exports.DETECTION_ENGINE_ALERTS_INDEX_DEFAULT = exports.DATA_VIEW_INDEX_PATTERN = exports.CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE = exports.CSP_LATEST_VULNERABILITIES_INGEST_TIMESTAMP_PIPELINE = exports.CSP_LATEST_FINDINGS_INGEST_TIMESTAMP_PIPELINE = exports.CSP_LATEST_FINDINGS_DATA_VIEW = exports.CSP_INGEST_TIMESTAMP_PIPELINE = exports.CSPM_POLICY_TEMPLATE = exports.CONFIGURATIONS = exports.CNVM_POLICY_TEMPLATE = exports.CLOUD_SECURITY_POSTURE_PACKAGE_NAME = exports.CLOUDBEAT_VULN_MGMT_GCP = exports.CLOUDBEAT_VULN_MGMT_AZURE = exports.CLOUDBEAT_VULN_MGMT_AWS = exports.CLOUDBEAT_VANILLA = exports.CLOUDBEAT_GKE = exports.CLOUDBEAT_GCP = exports.CLOUDBEAT_EKS = exports.CLOUDBEAT_AZURE = exports.CLOUDBEAT_AWS = exports.CLOUDBEAT_AKS = exports.CIS_K8S = exports.CIS_GCP = exports.CIS_EKS = exports.CIS_AZURE = exports.CIS_AWS = exports.BENCHMARK_SCORE_INDEX_TEMPLATE_NAME = exports.BENCHMARK_SCORE_INDEX_PATTERN = exports.BENCHMARK_SCORE_INDEX_DEFAULT_NS = exports.BENCHMARKS_ROUTE_PATH = exports.BENCHMARKS_API_CURRENT_VERSION = exports.AZURE_CREDENTIALS_TYPE_TO_FIELDS_MAP = exports.AWS_CREDENTIALS_TYPE_TO_FIELDS_MAP = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUS_ROUTE_PATH = '/internal/cloud_security_posture/status';
exports.STATUS_ROUTE_PATH = STATUS_ROUTE_PATH;
const STATUS_API_CURRENT_VERSION = '1';
exports.STATUS_API_CURRENT_VERSION = STATUS_API_CURRENT_VERSION;
const STATS_ROUTE_PATH = '/internal/cloud_security_posture/stats/{policy_template}';
exports.STATS_ROUTE_PATH = STATS_ROUTE_PATH;
const VULNERABILITIES_DASHBOARD_ROUTE_PATH = '/internal/cloud_security_posture/vulnerabilities_dashboard';
exports.VULNERABILITIES_DASHBOARD_ROUTE_PATH = VULNERABILITIES_DASHBOARD_ROUTE_PATH;
const BENCHMARKS_ROUTE_PATH = '/internal/cloud_security_posture/benchmarks';
exports.BENCHMARKS_ROUTE_PATH = BENCHMARKS_ROUTE_PATH;
const BENCHMARKS_API_CURRENT_VERSION = '1';
exports.BENCHMARKS_API_CURRENT_VERSION = BENCHMARKS_API_CURRENT_VERSION;
const FIND_CSP_RULE_TEMPLATE_ROUTE_PATH = '/internal/cloud_security_posture/rules/_find';
exports.FIND_CSP_RULE_TEMPLATE_ROUTE_PATH = FIND_CSP_RULE_TEMPLATE_ROUTE_PATH;
const FIND_CSP_RULE_TEMPLATE_API_CURRENT_VERSION = '1';
exports.FIND_CSP_RULE_TEMPLATE_API_CURRENT_VERSION = FIND_CSP_RULE_TEMPLATE_API_CURRENT_VERSION;
const DETECTION_RULE_ALERTS_STATUS_API_CURRENT_VERSION = '1';
exports.DETECTION_RULE_ALERTS_STATUS_API_CURRENT_VERSION = DETECTION_RULE_ALERTS_STATUS_API_CURRENT_VERSION;
const DETECTION_RULE_RULES_API_CURRENT_VERSION = '2023-10-31';
exports.DETECTION_RULE_RULES_API_CURRENT_VERSION = DETECTION_RULE_RULES_API_CURRENT_VERSION;
const GET_DETECTION_RULE_ALERTS_STATUS_PATH = '/internal/cloud_security_posture/detection_engine_rules/alerts/_status';
exports.GET_DETECTION_RULE_ALERTS_STATUS_PATH = GET_DETECTION_RULE_ALERTS_STATUS_PATH;
const CLOUD_SECURITY_POSTURE_PACKAGE_NAME = 'cloud_security_posture';
// TODO: REMOVE CSP_LATEST_FINDINGS_DATA_VIEW and replace it with LATEST_FINDINGS_INDEX_PATTERN
exports.CLOUD_SECURITY_POSTURE_PACKAGE_NAME = CLOUD_SECURITY_POSTURE_PACKAGE_NAME;
const CSP_LATEST_FINDINGS_DATA_VIEW = 'logs-cloud_security_posture.findings_latest-*';
exports.CSP_LATEST_FINDINGS_DATA_VIEW = CSP_LATEST_FINDINGS_DATA_VIEW;
const FINDINGS_INDEX_NAME = 'logs-cloud_security_posture.findings';
exports.FINDINGS_INDEX_NAME = FINDINGS_INDEX_NAME;
const FINDINGS_INDEX_PATTERN = 'logs-cloud_security_posture.findings-default*';
exports.FINDINGS_INDEX_PATTERN = FINDINGS_INDEX_PATTERN;
const FINDINGS_INDEX_DEFAULT_NS = 'logs-cloud_security_posture.findings-default';
exports.FINDINGS_INDEX_DEFAULT_NS = FINDINGS_INDEX_DEFAULT_NS;
const LATEST_FINDINGS_INDEX_TEMPLATE_NAME = 'logs-cloud_security_posture.findings_latest';
exports.LATEST_FINDINGS_INDEX_TEMPLATE_NAME = LATEST_FINDINGS_INDEX_TEMPLATE_NAME;
const LATEST_FINDINGS_INDEX_PATTERN = 'logs-cloud_security_posture.findings_latest-*';
exports.LATEST_FINDINGS_INDEX_PATTERN = LATEST_FINDINGS_INDEX_PATTERN;
const LATEST_FINDINGS_INDEX_DEFAULT_NS = 'logs-cloud_security_posture.findings_latest-default';
exports.LATEST_FINDINGS_INDEX_DEFAULT_NS = LATEST_FINDINGS_INDEX_DEFAULT_NS;
const LATEST_FINDINGS_RETENTION_POLICY = '26h';
exports.LATEST_FINDINGS_RETENTION_POLICY = LATEST_FINDINGS_RETENTION_POLICY;
const BENCHMARK_SCORE_INDEX_TEMPLATE_NAME = 'logs-cloud_security_posture.scores';
exports.BENCHMARK_SCORE_INDEX_TEMPLATE_NAME = BENCHMARK_SCORE_INDEX_TEMPLATE_NAME;
const BENCHMARK_SCORE_INDEX_PATTERN = 'logs-cloud_security_posture.scores-*';
exports.BENCHMARK_SCORE_INDEX_PATTERN = BENCHMARK_SCORE_INDEX_PATTERN;
const BENCHMARK_SCORE_INDEX_DEFAULT_NS = 'logs-cloud_security_posture.scores-default';
exports.BENCHMARK_SCORE_INDEX_DEFAULT_NS = BENCHMARK_SCORE_INDEX_DEFAULT_NS;
const VULNERABILITIES_INDEX_NAME = 'logs-cloud_security_posture.vulnerabilities';
exports.VULNERABILITIES_INDEX_NAME = VULNERABILITIES_INDEX_NAME;
const VULNERABILITIES_INDEX_PATTERN = 'logs-cloud_security_posture.vulnerabilities-default*';
exports.VULNERABILITIES_INDEX_PATTERN = VULNERABILITIES_INDEX_PATTERN;
const VULNERABILITIES_INDEX_DEFAULT_NS = 'logs-cloud_security_posture.vulnerabilities-default';
exports.VULNERABILITIES_INDEX_DEFAULT_NS = VULNERABILITIES_INDEX_DEFAULT_NS;
const LATEST_VULNERABILITIES_INDEX_TEMPLATE_NAME = 'logs-cloud_security_posture.vulnerabilities_latest';
exports.LATEST_VULNERABILITIES_INDEX_TEMPLATE_NAME = LATEST_VULNERABILITIES_INDEX_TEMPLATE_NAME;
const LATEST_VULNERABILITIES_INDEX_PATTERN = 'logs-cloud_security_posture.vulnerabilities_latest*';
exports.LATEST_VULNERABILITIES_INDEX_PATTERN = LATEST_VULNERABILITIES_INDEX_PATTERN;
const LATEST_VULNERABILITIES_INDEX_DEFAULT_NS = 'logs-cloud_security_posture.vulnerabilities_latest-default';
exports.LATEST_VULNERABILITIES_INDEX_DEFAULT_NS = LATEST_VULNERABILITIES_INDEX_DEFAULT_NS;
const LATEST_VULNERABILITIES_RETENTION_POLICY = '3d';
exports.LATEST_VULNERABILITIES_RETENTION_POLICY = LATEST_VULNERABILITIES_RETENTION_POLICY;
const DATA_VIEW_INDEX_PATTERN = 'logs-*';
exports.DATA_VIEW_INDEX_PATTERN = DATA_VIEW_INDEX_PATTERN;
const SECURITY_DEFAULT_DATA_VIEW_ID = 'security-solution-default';
exports.SECURITY_DEFAULT_DATA_VIEW_ID = SECURITY_DEFAULT_DATA_VIEW_ID;
const CSP_INGEST_TIMESTAMP_PIPELINE = 'cloud_security_posture_add_ingest_timestamp_pipeline';
exports.CSP_INGEST_TIMESTAMP_PIPELINE = CSP_INGEST_TIMESTAMP_PIPELINE;
const CSP_LATEST_FINDINGS_INGEST_TIMESTAMP_PIPELINE = 'cloud_security_posture_latest_index_add_ingest_timestamp_pipeline';
exports.CSP_LATEST_FINDINGS_INGEST_TIMESTAMP_PIPELINE = CSP_LATEST_FINDINGS_INGEST_TIMESTAMP_PIPELINE;
const CSP_LATEST_VULNERABILITIES_INGEST_TIMESTAMP_PIPELINE = 'cloud_security_posture_latest_vulnerabilities_index_add_ingest_timestamp_pipeline';
exports.CSP_LATEST_VULNERABILITIES_INGEST_TIMESTAMP_PIPELINE = CSP_LATEST_VULNERABILITIES_INGEST_TIMESTAMP_PIPELINE;
const RULE_PASSED = `passed`;
exports.RULE_PASSED = RULE_PASSED;
const RULE_FAILED = `failed`;
exports.RULE_FAILED = RULE_FAILED;
const POSTURE_TYPE_ALL = 'all';

// A mapping of in-development features to their status. These features should be hidden from users but can be easily
// activated via a simple code change in a single location.
exports.POSTURE_TYPE_ALL = POSTURE_TYPE_ALL;
const INTERNAL_FEATURE_FLAGS = {
  showManageRulesMock: false,
  showFindingFlyoutEvidence: true
};
exports.INTERNAL_FEATURE_FLAGS = INTERNAL_FEATURE_FLAGS;
const CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE = 'csp-rule-template';
exports.CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE = CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE;
const CLOUDBEAT_VANILLA = 'cloudbeat/cis_k8s';
exports.CLOUDBEAT_VANILLA = CLOUDBEAT_VANILLA;
const CLOUDBEAT_EKS = 'cloudbeat/cis_eks';
exports.CLOUDBEAT_EKS = CLOUDBEAT_EKS;
const CLOUDBEAT_AKS = 'cloudbeat/cis_aks';
exports.CLOUDBEAT_AKS = CLOUDBEAT_AKS;
const CLOUDBEAT_GKE = 'cloudbeat/cis_gke';
exports.CLOUDBEAT_GKE = CLOUDBEAT_GKE;
const CLOUDBEAT_AWS = 'cloudbeat/cis_aws';
exports.CLOUDBEAT_AWS = CLOUDBEAT_AWS;
const CLOUDBEAT_GCP = 'cloudbeat/cis_gcp';
exports.CLOUDBEAT_GCP = CLOUDBEAT_GCP;
const CLOUDBEAT_AZURE = 'cloudbeat/cis_azure';
exports.CLOUDBEAT_AZURE = CLOUDBEAT_AZURE;
const CLOUDBEAT_VULN_MGMT_AWS = 'cloudbeat/vuln_mgmt_aws';
exports.CLOUDBEAT_VULN_MGMT_AWS = CLOUDBEAT_VULN_MGMT_AWS;
const CLOUDBEAT_VULN_MGMT_GCP = 'cloudbeat/vuln_mgmt_gcp';
exports.CLOUDBEAT_VULN_MGMT_GCP = CLOUDBEAT_VULN_MGMT_GCP;
const CLOUDBEAT_VULN_MGMT_AZURE = 'cloudbeat/vuln_mgmt_azure';
exports.CLOUDBEAT_VULN_MGMT_AZURE = CLOUDBEAT_VULN_MGMT_AZURE;
const CIS_AWS = 'cis_aws';
exports.CIS_AWS = CIS_AWS;
const CIS_GCP = 'cis_gcp';
exports.CIS_GCP = CIS_GCP;
const CIS_K8S = 'cis_k8s';
exports.CIS_K8S = CIS_K8S;
const CIS_EKS = 'cis_eks';
exports.CIS_EKS = CIS_EKS;
const CIS_AZURE = 'cis_azure';
exports.CIS_AZURE = CIS_AZURE;
const KSPM_POLICY_TEMPLATE = 'kspm';
exports.KSPM_POLICY_TEMPLATE = KSPM_POLICY_TEMPLATE;
const CSPM_POLICY_TEMPLATE = 'cspm';
exports.CSPM_POLICY_TEMPLATE = CSPM_POLICY_TEMPLATE;
const VULN_MGMT_POLICY_TEMPLATE = 'vuln_mgmt';
exports.VULN_MGMT_POLICY_TEMPLATE = VULN_MGMT_POLICY_TEMPLATE;
const CNVM_POLICY_TEMPLATE = 'cnvm';
exports.CNVM_POLICY_TEMPLATE = CNVM_POLICY_TEMPLATE;
const SUPPORTED_POLICY_TEMPLATES = [KSPM_POLICY_TEMPLATE, CSPM_POLICY_TEMPLATE, VULN_MGMT_POLICY_TEMPLATE];
exports.SUPPORTED_POLICY_TEMPLATES = SUPPORTED_POLICY_TEMPLATES;
const SUPPORTED_CLOUDBEAT_INPUTS = [CLOUDBEAT_VANILLA, CLOUDBEAT_EKS, CLOUDBEAT_AWS, CLOUDBEAT_GCP, CLOUDBEAT_AZURE, CLOUDBEAT_VULN_MGMT_AWS, CLOUDBEAT_VULN_MGMT_GCP, CLOUDBEAT_VULN_MGMT_AZURE];
exports.SUPPORTED_CLOUDBEAT_INPUTS = SUPPORTED_CLOUDBEAT_INPUTS;
const POSTURE_TYPES = {
  [KSPM_POLICY_TEMPLATE]: KSPM_POLICY_TEMPLATE,
  [CSPM_POLICY_TEMPLATE]: CSPM_POLICY_TEMPLATE,
  [VULN_MGMT_POLICY_TEMPLATE]: VULN_MGMT_POLICY_TEMPLATE,
  [POSTURE_TYPE_ALL]: POSTURE_TYPE_ALL
};
exports.POSTURE_TYPES = POSTURE_TYPES;
const VULNERABILITIES = 'vulnerabilities';
exports.VULNERABILITIES = VULNERABILITIES;
const CONFIGURATIONS = 'configurations';
exports.CONFIGURATIONS = CONFIGURATIONS;
const VULNERABILITIES_SEVERITY = {
  LOW: 'LOW',
  MEDIUM: 'MEDIUM',
  HIGH: 'HIGH',
  CRITICAL: 'CRITICAL',
  UNKNOWN: 'UNKNOWN'
};
exports.VULNERABILITIES_SEVERITY = VULNERABILITIES_SEVERITY;
const VULNERABILITIES_ENUMERATION = 'CVE';
exports.VULNERABILITIES_ENUMERATION = VULNERABILITIES_ENUMERATION;
const AWS_CREDENTIALS_TYPE_TO_FIELDS_MAP = {
  assume_role: ['role_arn'],
  direct_access_keys: ['access_key_id', 'secret_access_key'],
  temporary_keys: ['access_key_id', 'secret_access_key', 'session_token'],
  shared_credentials: ['shared_credential_file', 'credential_profile_name'],
  cloud_formation: []
};
exports.AWS_CREDENTIALS_TYPE_TO_FIELDS_MAP = AWS_CREDENTIALS_TYPE_TO_FIELDS_MAP;
const SETUP_ACCESS_CLOUD_SHELL = 'google_cloud_shell';
exports.SETUP_ACCESS_CLOUD_SHELL = SETUP_ACCESS_CLOUD_SHELL;
const SETUP_ACCESS_MANUAL = 'manual';
exports.SETUP_ACCESS_MANUAL = SETUP_ACCESS_MANUAL;
const DETECTION_ENGINE_ALERTS_INDEX_DEFAULT = '.alerts-security.alerts-default';
exports.DETECTION_ENGINE_ALERTS_INDEX_DEFAULT = DETECTION_ENGINE_ALERTS_INDEX_DEFAULT;
const GCP_CREDENTIALS_TYPE_TO_FIELDS_MAP = {
  'credentials-file': ['gcp.credentials.file'],
  'credentials-json': ['gcp.credentials.json']
};
exports.GCP_CREDENTIALS_TYPE_TO_FIELDS_MAP = GCP_CREDENTIALS_TYPE_TO_FIELDS_MAP;
const AZURE_CREDENTIALS_TYPE_TO_FIELDS_MAP = {
  arm_template: [],
  service_principal_with_client_secret: ['azure.credentials.tenant_id', 'azure.credentials.client_id', 'azure.credentials.client_secret'],
  service_principal_with_client_certificate: ['azure.credentials.tenant_id', 'azure.credentials.client_id', 'azure.credentials.client_certificate_path', 'azure.credentials.client_certificate_password'],
  service_principal_with_client_username_and_password: ['azure.credentials.tenant_id', 'azure.credentials.client_id', 'azure.credentials.client_username', 'azure.credentials.client_password'],
  managed_identity: [],
  manual: []
};
exports.AZURE_CREDENTIALS_TYPE_TO_FIELDS_MAP = AZURE_CREDENTIALS_TYPE_TO_FIELDS_MAP;