"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apmConfigSchema = _configSchema.schema.object({
  url: _configSchema.schema.maybe(_configSchema.schema.string()),
  secret_token: _configSchema.schema.maybe(_configSchema.schema.string()),
  ui: _configSchema.schema.maybe(_configSchema.schema.object({
    url: _configSchema.schema.maybe(_configSchema.schema.string())
  }))
});
const configSchema = _configSchema.schema.object({
  apm: _configSchema.schema.maybe(apmConfigSchema),
  base_url: _configSchema.schema.maybe(_configSchema.schema.string()),
  cname: _configSchema.schema.maybe(_configSchema.schema.string()),
  deployment_url: _configSchema.schema.maybe(_configSchema.schema.string()),
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  billing_url: _configSchema.schema.maybe(_configSchema.schema.string()),
  performance_url: _configSchema.schema.maybe(_configSchema.schema.string()),
  users_and_roles_url: _configSchema.schema.maybe(_configSchema.schema.string()),
  organization_url: _configSchema.schema.maybe(_configSchema.schema.string()),
  profile_url: _configSchema.schema.maybe(_configSchema.schema.string()),
  projects_url: (0, _configSchema.offeringBasedSchema)({
    serverless: _configSchema.schema.string({
      defaultValue: '/projects/'
    })
  }),
  trial_end_date: _configSchema.schema.maybe(_configSchema.schema.string()),
  is_elastic_staff_owned: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  serverless: _configSchema.schema.maybe(_configSchema.schema.object({
    project_id: _configSchema.schema.maybe(_configSchema.schema.string()),
    project_name: _configSchema.schema.maybe(_configSchema.schema.string()),
    project_type: _configSchema.schema.maybe(_configSchema.schema.string())
  },
  // avoid future chicken-and-egg situation with the component populating the config
  {
    unknowns: 'ignore'
  }))
});
const config = {
  exposeToBrowser: {
    base_url: true,
    cname: true,
    deployment_url: true,
    id: true,
    billing_url: true,
    users_and_roles_url: true,
    performance_url: true,
    organization_url: true,
    profile_url: true,
    projects_url: true,
    trial_end_date: true,
    is_elastic_staff_owned: true,
    serverless: {
      project_id: true,
      project_name: true,
      project_type: true
    }
  },
  schema: configSchema
};
exports.config = config;