/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.cloudDefend_bundle_jsonpfunction=window.cloudDefend_bundle_jsonpfunction||[]).push([[4],{68:function(e){e.exports=JSON.parse('{"$id":"https://elastic.co/cloud-defend/policy-schema.json","$schema":"http://json-schema.org/draft-07/schema#","$comment":"policy-version=1.0.0","type":"object","anyOf":[{"required":["file"]},{"required":["process"]}],"additionalProperties":true,"properties":{"version":{"type":"string"},"file":{"type":"object","required":["selectors","responses"],"properties":{"selectors":{"type":"array","minItems":1,"items":{"$ref":"#/$defs/fileSelector"}},"responses":{"type":"array","minItems":1,"items":{"$ref":"#/$defs/fileResponse"}}}},"process":{"type":"object","required":["selectors","responses"],"properties":{"selectors":{"type":"array","minItems":1,"items":{"$ref":"#/$defs/processSelector"}},"responses":{"type":"array","minItems":1,"items":{"$ref":"#/$defs/processResponse"}}}}},"$defs":{"fileSelector":{"type":"object","required":["name"],"additionalProperties":true,"anyOf":[{"required":["operation"]},{"required":["containerImageName"]},{"required":["containerImageTag"]},{"required":["containerImageFullName"]},{"required":["kubernetesClusterId"]},{"required":["kubernetesClusterName"]},{"required":["kubernetesNamespace"]},{"required":["kubernetesPodLabel"]},{"required":["kubernetesPodName"]},{"required":["targetFilePath"]},{"required":["ignoreVolumeMounts"]},{"required":["ignoreVolumeFiles"]}],"properties":{"name":{"type":"string"},"operation":{"type":"array","minItems":1,"items":{"enum":["createExecutable","modifyExecutable","createFile","modifyFile","deleteFile"]}},"containerImageName":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^([a-z0-9]+(?:[._-][a-z0-9]+)*)$"}},"containerImageTag":{"type":"array","minItems":1,"items":{"type":"string"}},"containerImageFullName":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^(?:\\\\[[a-fA-F0-9:]+\\\\]|(?:[a-zA-Z0-9-](?:\\\\.[a-z0-9]+)*)+)(?::[0-9]+)?(?:\\\\/[a-z0-9]+(?:[._-][a-z0-9]+)*)+$"}},"kubernetesClusterId":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesClusterName":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesNamespace":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesPodLabel":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^([a-zA-Z0-9\\\\.\\\\-]+\\\\/)?[a-zA-Z0-9\\\\.\\\\-]+:[a-zA-Z0-9\\\\.\\\\-\\\\_]*\\\\*?$"}},"kubernetesPodName":{"type":"array","minItems":1,"items":{"type":"string"}},"targetFilePath":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^(?:\\\\/[^\\\\/\\\\*]+)*(?:\\\\/\\\\*|\\\\/\\\\*\\\\*)?$","minLength":1}},"ignoreVolumeMounts":{"type":"boolean","description":"Ignore all volume mounts. e.g directories, files, configMaps, secrets etc...\\nNote: should not be used with ignoreVolumeFiles"},"ignoreVolumeFiles":{"type":"boolean","description":"Ignore file mounts. e.g files, configMaps, secrets\\nNote: should not be used with ignoreVolumeMounts"}},"dependencies":{"ignoreVolumeMounts":{"not":{"required":["ignoreVolumeFiles"]}},"containerImageFullName":{"not":{"required":["containerImageName"]}}}},"processSelector":{"type":"object","required":["name"],"additionalProperties":true,"anyOf":[{"required":["operation"]},{"required":["containerImageName"]},{"required":["containerImageTag"]},{"required":["containerImageFullName"]},{"required":["kubernetesClusterId"]},{"required":["kubernetesClusterName"]},{"required":["kubernetesNamespace"]},{"required":["kubernetesPodLabel"]},{"required":["kubernetesPodName"]},{"required":["processExecutable"]},{"required":["processName"]},{"required":["sessionLeaderInteractive"]}],"properties":{"name":{"type":"string"},"operation":{"type":"array","minItems":1,"items":{"enum":["fork","exec"]}},"containerImageName":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^[a-z0-9]+(?:[._-][a-z0-9]+)*$"}},"containerImageTag":{"type":"array","minItems":1,"items":{"type":"string"}},"containerImageFullName":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^(?:\\\\[[a-fA-F0-9:]+\\\\]|(?:[a-zA-Z0-9-](?:\\\\.[a-z0-9]+)*)+)(?::[0-9]+)?(?:\\\\/[a-z0-9]+(?:[._-][a-z0-9]+)*)+$"}},"kubernetesClusterId":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesClusterName":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesNamespace":{"type":"array","minItems":1,"items":{"type":"string"}},"kubernetesPodLabel":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^([a-zA-Z0-9\\\\.\\\\-]+\\\\/)?[a-zA-Z0-9\\\\.\\\\-]+:[a-zA-Z0-9\\\\.\\\\-\\\\_]*\\\\*?$"}},"kubernetesPodName":{"type":"array","minItems":1,"items":{"type":"string"}},"processExecutable":{"type":"array","minItems":1,"items":{"type":"string","pattern":"^(?:\\\\/[^\\\\/\\\\*]+)*(?:\\\\/\\\\*|\\\\/\\\\*\\\\*)?$","minLength":1}},"processName":{"type":"array","minItems":1,"items":{"type":"string"}},"sessionLeaderInteractive":{"type":"boolean"}},"dependencies":{"containerImageFullName":{"not":{"required":["containerImageName"]}}}},"fileResponse":{"type":"object","required":["match","actions"],"additionalProperties":true,"properties":{"match":{"type":"array","minItems":1,"items":{"type":"string"}},"exclude":{"type":"array","items":{"type":"string"}},"actions":{"type":"array","minItems":1,"items":{"enum":["alert","block","log"]}}}},"processResponse":{"type":"object","required":["match","actions"],"additionalProperties":true,"properties":{"match":{"type":"array","minItems":1,"items":{"type":"string"}},"exclude":{"type":"array","items":{"type":"string"}},"actions":{"type":"array","minItems":1,"items":{"enum":["alert","block","log"]}}}}}}')},78:function(e,t,n){"use strict";n.r(t),n.d(t,"CloudDefendFleetPolicyReplaceDefineStepExtension",(function(){return Cn})),n.d(t,"default",(function(){return Cn}));var i=n(1),r=n.n(i),o=n(3),a=n(5),s=n(36),c=n(8);const l=c.i18n.translate("xpack.cloudDefend.name",{defaultMessage:"Name"}),u=c.i18n.translate("xpack.cloudDefend.description",{defaultMessage:"Description"}),d=c.i18n.translate("xpack.cloudDefend.enableControl",{defaultMessage:"Enable policy"}),p=c.i18n.translate("xpack.cloudDefend.enableControlHelp",{defaultMessage:"Enables drift prevention, alert, and logging policy shown below."}),g=c.i18n.translate("xpack.cloudDefend.controlGeneralView",{defaultMessage:"General view"}),f=c.i18n.translate("xpack.cloudDefend.controlYamlView",{defaultMessage:"YAML view"});var m=n(25);const b=c.i18n.translate("xpack.cloudDefend.fileSelector",{defaultMessage:"File selector"}),h=c.i18n.translate("xpack.cloudDefend.processSelector",{defaultMessage:"Process selector"}),j=c.i18n.translate("xpack.cloudDefend.networkSelector",{defaultMessage:"Network (coming soon)"}),v=c.i18n.translate("xpack.cloudDefend.fileResponse",{defaultMessage:"File response"}),x=c.i18n.translate("xpack.cloudDefend.processResponse",{defaultMessage:"Process response"}),y=c.i18n.translate("xpack.cloudDefend.networkResponse",{defaultMessage:"Network (coming soon)"}),O=c.i18n.translate("xpack.cloudDefend.conditions",{defaultMessage:"Conditions: "}),k=c.i18n.translate("xpack.cloudDefend.controlDuplicate",{defaultMessage:"Duplicate"}),E=c.i18n.translate("xpack.cloudDefend.controlRemove",{defaultMessage:"Remove"}),C=c.i18n.translate("xpack.cloudDefend.controlSelectors",{defaultMessage:"Selectors"}),I=c.i18n.translate("xpack.cloudDefend.controlSelectorsHelp",{defaultMessage:"Create file or process selectors to match on operations and or conditions of interest."}),w=c.i18n.translate("xpack.cloudDefend.controlResponses",{defaultMessage:"Responses"}),M=c.i18n.translate("xpack.cloudDefend.controlResponsesHelp",{defaultMessage:'Use responses to map one or more selectors to a set of actions. Selectors can also be used to "exclude" events.'}),A=c.i18n.translate("xpack.cloudDefend.controlMatchSelectors",{defaultMessage:"Match selectors"}),S=c.i18n.translate("xpack.cloudDefend.controlExcludeSelectors",{defaultMessage:"Exclude selectors"}),F=c.i18n.translate("xpack.cloudDefend.controlExclude",{defaultMessage:"Exclude"}),T=c.i18n.translate("xpack.cloudDefend.controlResponseActions",{defaultMessage:"Actions"}),_=c.i18n.translate("xpack.cloudDefend.controlResponseActionLog",{defaultMessage:"Log"}),D=c.i18n.translate("xpack.cloudDefend.controlResponseActionAlert",{defaultMessage:"Alert"}),N=c.i18n.translate("xpack.cloudDefend.controlResponseActionBlock",{defaultMessage:"Block"}),R=c.i18n.translate("xpack.cloudDefend.controlResponseActionBlockHelp",{defaultMessage:"Alert action must be enabled to block an event."}),P=(c.i18n.translate("xpack.cloudDefend.controlResponseActionAlertAndBlock",{defaultMessage:"Alert and block"}),c.i18n.translate("xpack.cloudDefend.addResponse",{defaultMessage:"Add response"})),z=c.i18n.translate("xpack.cloudDefend.addSelector",{defaultMessage:"Add selector"}),L=c.i18n.translate("xpack.cloudDefend.addSelectorCondition",{defaultMessage:"Add condition"}),V=c.i18n.translate("xpack.cloudDefend.name",{defaultMessage:"Name"}),q=c.i18n.translate("xpack.cloudDefend.unusedSelector",{defaultMessage:"Not in use"}),$=c.i18n.translate("xpack.cloudDefend.unusedSelectorHelp",{defaultMessage:"This selector is not in use by any response."}),B=c.i18n.translate("xpack.cloudDefend.errorInvalidTargetFilePath",{defaultMessage:'"Target file path" values must use absolute paths. A trailing * wildcard may be used to match all files in the target directory. Use double ** to match all files recursively. e.g /etc/**'}),W=c.i18n.translate("xpack.cloudDefend.errorInvalidProcessExecutable",{defaultMessage:'"Process executable" values must use absolute paths. A trailing * wildcard may be used to match all files in the target directory. Use double ** to match all files recursively. e.g /usr/bin/**'}),U=c.i18n.translate("xpack.cloudDefend.errorInvalidPodLabel",{defaultMessage:'Kubernetes pod label values must have the format: "key:value". A wildcard "*" can be used at the end of the value. e.g. "key:val*". To match on an empty label value, use "key:".'}),J=c.i18n.translate("xpack.cloudDefend.errorInvalidFullContainerImageName",{defaultMessage:'"Full container image name" values must be in the format: image_repo/image_name e.g. "docker.io/nginx"'}),H=c.i18n.translate("xpack.cloudDefend.errorConditionRequired",{defaultMessage:"At least one condition per selector is required."}),G=c.i18n.translate("xpack.cloudDefend.errorDuplicateName",{defaultMessage:"This name is already used by another selector."}),K=c.i18n.translate("xpack.cloudDefend.errorInvalidName",{defaultMessage:"Selector names must be alphanumeric and contain no spaces."}),Z=c.i18n.translate("xpack.cloudDefend.errorValueRequired",{defaultMessage:"At least one value is required."}),X=c.i18n.translate("xpack.cloudDefend.errorActionRequired",{defaultMessage:"At least one action is required."}),Y=c.i18n.translate("xpack.cloudDefend.errorBlockActionRequiresTargetFilePath",{defaultMessage:'The "block" action requires targetFilePath be included in all "match" selectors using FIM operations or in at least one "exclude" selector. Note that selectors without operation will match on all operations, including createFile, modifyFile or deleteFile'}),Q=c.i18n.translate("xpack.cloudDefend.warningFIMUsingSlashStarStarTitle",{defaultMessage:"Warning: Blocking FIM operations"}),ee=c.i18n.translate("xpack.cloudDefend.warningFIMUsingSlashStarStarText",{defaultMessage:"It is dangerous to block FIM operations using a targetFilePath of /**. This can lead to system instability. Note that selectors without operation will match on all operations, including createFile, modifyFile or deleteFile"}),te={containerImageFullName:{type:"stringArray",pattern:"^(?:\\[[a-fA-F0-9:]+\\]|(?:[a-zA-Z0-9-](?:\\.[a-z0-9]+)*)+)(?::[0-9]+)?(?:\\/[a-z0-9]+(?:[._-][a-z0-9]+)*)+$",patternError:J,not:["containerImageName"]},containerImageName:{type:"stringArray",pattern:"^([a-z0-9]+(?:[._-][a-z0-9]+)*)$",not:["containerImageFullName"]},containerImageTag:{type:"stringArray"},kubernetesClusterId:{type:"stringArray"},kubernetesClusterName:{type:"stringArray"},kubernetesNamespace:{type:"stringArray"},kubernetesPodName:{type:"stringArray"},kubernetesPodLabel:{type:"stringArray",pattern:"^([a-zA-Z0-9\\.\\-]+\\/)?[a-zA-Z0-9\\.\\-]+:[a-zA-Z0-9\\.\\-\\_]*\\*?$",patternError:U},operation:{type:"stringArray",values:{file:["createExecutable","modifyExecutable","createFile","modifyFile","deleteFile"],process:["fork","exec"]}},targetFilePath:{selectorType:"file",type:"stringArray",maxValueBytes:255,pattern:"^(?:\\/[^\\/\\*]+)*(?:\\/\\*|\\/\\*\\*)?$",patternError:B},ignoreVolumeFiles:{selectorType:"file",type:"flag",not:["ignoreVolumeMounts"]},ignoreVolumeMounts:{selectorType:"file",type:"flag",not:["ignoreVolumeFiles"]},processExecutable:{selectorType:"process",type:"stringArray",not:["processName"],pattern:"^(?:\\/[^\\/\\*]+)*(?:\\/\\*|\\/\\*\\*)?$",patternError:W},processName:{selectorType:"process",type:"stringArray",not:["processExecutable"],maxValueBytes:15},sessionLeaderInteractive:{selectorType:"process",type:"boolean"}},ne={type:"file",name:"Untitled",operation:["createExecutable","modifyExecutable"]},ie={type:"process",name:"Untitled",operation:["fork","exec"]},re={type:"file",match:[],actions:["alert"]},oe={type:"process",match:[],actions:["alert"]};var ae=n(39);function se(e){return"process"===e?"gear":"document"}function ce(e){const t=e.replace(/([A-Z])/g," $1").toLowerCase();return t[0].toUpperCase()+t.slice(1)}function le(e,t){const n={process:0,file:0};return e.forEach((e=>{n[e.type]++})),t.forEach((e=>{n[e.type]++})),n}function ue(e){return e&&(!e.operation||0===e.operation.length||e.operation.some((e=>ae.b.indexOf(e)>=0)))}function de(e,t,n,i){return!(!n||!n.reduce(((n,r)=>{const o=e.find((e=>e.name===r)),a=!ue(o)||!(!o||!t.reduce(((e,t)=>e&&o.hasOwnProperty(t)),!0));return i?n&&a:n||a}),i))}function pe(e,t){const n=[];return t.forEach((t=>{var i;if(null!==(i=t.actions)&&void 0!==i&&i.includes("block")){const i=de(e,["targetFilePath"],t.exclude);de(e,["targetFilePath"],t.match,!0)||i||n.push(Y)}})),n}function ge(e,t){const n=[],i=te[e].maxValueBytes||ae.d,{pattern:r,patternError:o}=te[e];return null==t||t.forEach((t=>{0===(null==t?void 0:t.length)?n.push(c.i18n.translate("xpack.cloudDefend.errorGenericEmptyValue",{defaultMessage:'"{condition}" values cannot be empty',values:{condition:e}})):r&&!new RegExp(r).test(t)&&(o?n.push(o):n.push(c.i18n.translate("xpack.cloudDefend.errorGenericRegexFailure",{defaultMessage:'"{condition}" values must match the pattern: /{pattern}/',values:{condition:e,pattern:r}}))),new Blob([t]).size>i&&n.push(c.i18n.translate("xpack.cloudDefend.errorMaxValueBytesExceeded",{defaultMessage:'"{condition}" values cannot exceed {maxValueBytes} bytes',values:{condition:e,maxValueBytes:i}}))})),Object(m.uniq)(n)}const fe=()=>{const{euiTheme:e}=Object(o.useEuiTheme)(),{size:t,border:n}=e;return Object(i.useMemo)((()=>({accordion:{borderRadius:n.radius.medium,border:n.thin,"> .euiAccordion__triggerWrapper":{padding:t.m}},conditionsBadge:{display:"inline"},verticalDivider:{display:"inline-block",verticalAlign:"middle",width:"1px",height:"20px",border:n.thin,borderRight:0,borderTop:0,borderBottom:0,marginLeft:t.base,marginRight:t.base}})),[n.radius.medium,n.thin,t.base,t.m])};var me=n(0);const be=({label:e,prop:t,selector:n,onChangeBooleanCondition:r,onRemoveCondition:a})=>{const s=n[t],c=Object(i.useCallback)((e=>{r(t,e.target.checked)}),[r,t]);return Object(me.jsx)(o.EuiFormRow,{label:e,fullWidth:!0,key:t},Object(me.jsx)(o.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiCheckbox,{id:t,label:e,checked:s,onChange:c})),Object(me.jsx)(o.EuiFlexItem,{grow:!1},Object(me.jsx)(o.EuiButtonIcon,{iconType:"cross",onClick:()=>a(t),"aria-label":"Remove condition","data-test-subj":"cloud-defend-btnremovecondition-"+t}))))},he=({label:e,prop:t,onRemoveCondition:n})=>Object(me.jsx)(o.EuiFormRow,{label:e,fullWidth:!0,key:t},Object(me.jsx)(o.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiText,{size:"s"},Object(me.jsx)("p",null,Object(me.jsx)("small",null,(e=>{switch(e){case"ignoreVolumeMounts":return c.i18n.translate("xpack.cloudDefend.ignoreVolumeMountsHelp",{defaultMessage:"Ignore operations on all volume mounts."});case"ignoreVolumeFiles":return c.i18n.translate("xpack.cloudDefend.ignoreVolumeFilesHelp",{defaultMessage:"Ignore operations on file mounts only. e.g mounted files, configMaps, secrets etc..."});default:return""}})(t))))),Object(me.jsx)(o.EuiFlexItem,{grow:!1},Object(me.jsx)(o.EuiButtonIcon,{iconType:"cross",onClick:()=>n(t),"aria-label":"Remove condition","data-test-subj":"cloud-defend-btnremovecondition-"+t})))),je=({label:e,prop:t,selector:n,errorMap:i,onRemoveCondition:r,onAddValueToCondition:a,onChangeStringArrayCondition:s})=>{const c=n[t],l=(null==c?void 0:c.map((e=>({label:e,value:e}))))||[],u=function(e,t){var n;const i=te[t];return Array.isArray(i.values)?i.values:null!=i&&null!==(n=i.values)&&void 0!==n&&n[e]?i.values[e]:void 0}(n.type,t);return Object(me.jsx)(o.EuiFormRow,{label:e,fullWidth:!0,key:t,isInvalid:!!i.hasOwnProperty(t)},Object(me.jsx)(o.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiComboBox,{"aria-label":e,fullWidth:!0,onCreateOption:u?void 0:e=>a(t,e),selectedOptions:l,options:u?u.map((e=>({label:e,value:e}))):l,onChange:e=>s(t,e.map((e=>e.value))),isClearable:!0,"data-test-subj":"cloud-defend-selectorcondition-"+t})),Object(me.jsx)(o.EuiFlexItem,{grow:!1},Object(me.jsx)(o.EuiButtonIcon,{iconType:"cross",onClick:()=>r(t),"aria-label":"Remove condition","data-test-subj":"cloud-defend-btnremovecondition-"+t}))))},ve=({selector:e,selectors:t,usedByResponse:n,index:a,onRemove:s,onDuplicate:l,onChange:u})=>{const[d,p]=Object(i.useState)(t.length-1===a?"open":"closed"),[g,f]=Object(i.useState)(!1),[m,b]=Object(i.useState)(!1),[h,j]=Object(i.useState)({}),v=fe(),x=Object(i.useCallback)((()=>{f(!g)}),[g]),y=Object(i.useCallback)((()=>{f(!1)}),[]),C=Object(i.useCallback)((()=>{b(!m)}),[m]),I=Object(i.useCallback)((()=>{b(!1)}),[]),w=Object(i.useMemo)((()=>{return t=e.type,Object.keys(te).filter((e=>{const n=te[e];return!n.selectorType||n.selectorType===t}));var t}),[e]),M=Object(i.useMemo)((()=>w.filter((t=>!e.hasOwnProperty(t)))),[w,e]),A=Object(i.useMemo)((()=>Object.keys(e).filter((e=>!["type","hasErrors","name"].includes(e)))),[e]),S=Object(i.useCallback)((()=>{t.length>1&&s(a),y()}),[y,a,s,t.length]),F=Object(i.useCallback)((()=>{l(e),y()}),[y,l,e]),T=Object(i.useCallback)((n=>{const i=[],r=n.currentTarget.value;t.find((e=>e.name===r))&&i.push(G),ae.g.test(r)||i.push(K),i.length?h.name=i:delete h.name,j({...h});const o={...e};o.name=r,o.hasErrors=Object.keys(h).length>0||0===A.length,u(o,a)}),[h,a,A,u,e,t]),_=Object(i.useCallback)(((t,n)=>{const i={...e,[t]:n},r=[];0===n.length&&r.push(Z);const o=ge(t,n);o.length>0&&r.push(...o),r.length?h[t]=r:delete h[t],i.hasErrors=Object.keys(h).length>0||0===A.length,j({...h}),u(i,a)}),[h,a,A,u,e]),D=Object(i.useCallback)(((t,n)=>{const i={...e,[t]:n};u(i,a)}),[a,u,e]),N=Object(i.useCallback)((e=>{const t=te[e].type;"flag"===t||"boolean"===t?D(e,!0):_(e,[]),I()}),[I,D,_]),R=Object(i.useCallback)((t=>{const n={...e};delete n[t],delete h[t],j({...h}),n.hasErrors=Object.keys(h).length>0||1===A.length,u(n,a),I()}),[I,A,h,a,u,e]),P=Object(i.useCallback)(((t,n)=>{const i=n.trim(),r=e[t];r&&-1===r.indexOf(i)&&_(t,[...r,i])}),[_,e]),z=Object(i.useMemo)((()=>{const e=Object.keys(h).reduce(((e,t)=>e.concat(h[t])),[]);return 0===A.length&&e.push(H),e}),[h,A]),B=Object(i.useCallback)((e=>{p(e?"open":"closed")}),[]);return Object(me.jsx)(o.EuiAccordion,{id:e.name,forceState:d,onToggle:B,"data-test-subj":"cloud-defend-selector",paddingSize:"m",buttonContent:Object(me.jsx)(o.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiToolTip,{content:(W=e.type,"process"===W?c.i18n.translate("xpack.cloudDefend.processSelectorIconTooltip",{defaultMessage:"A process selector. Matches only on process operations."}):c.i18n.translate("xpack.cloudDefend.fileSelectorIconTooltip",{defaultMessage:"A file selector. Matches only on file operations."}))},Object(me.jsx)(o.EuiIcon,{color:"primary",type:se(e.type)}))),Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiText,{size:"s"},Object(me.jsx)("b",null,e.name)))),css:v.accordion,extraAction:Object(me.jsx)(o.EuiFlexGroup,{alignItems:"center",gutterSize:"none"},Object(me.jsx)("div",null,"closed"===d&&Object(me.jsx)(r.a.Fragment,null,Object(me.jsx)(o.EuiText,{css:v.conditionsBadge,size:"xs"},Object(me.jsx)("b",null,O)),Object(me.jsx)(o.EuiBadge,{title:A.join(","),color:"hollow","data-test-subj":"cloud-defend-conditions-count"},A.length)),!n&&Object(me.jsx)(o.EuiBadge,{title:$,color:"warning"},q),Object(me.jsx)("div",{css:v.verticalDivider})),Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiPopover,{id:e.name,button:Object(me.jsx)(o.EuiButtonIcon,{iconType:"boxesHorizontal",onClick:x,"aria-label":"Selector options","data-test-subj":"cloud-defend-btnselectorpopover"}),isOpen:g,closePopover:y,panelPaddingSize:"none",anchorPosition:"downLeft"},Object(me.jsx)(o.EuiContextMenuPanel,{size:"s",items:[Object(me.jsx)(o.EuiContextMenuItem,{key:"duplicate",icon:"copy",onClick:F,"data-test-subj":"cloud-defend-btnduplicateselector"},k),Object(me.jsx)(o.EuiContextMenuItem,{key:"remove",icon:"trash",disabled:t.length<2,onClick:S,"data-test-subj":"cloud-defend-btndeleteselector"},E)]}))))},Object(me.jsx)(o.EuiForm,{component:"form",error:z,isInvalid:z.length>0},Object(me.jsx)(o.EuiFormRow,{label:V,fullWidth:!0,isInvalid:!!h.hasOwnProperty("name")},Object(me.jsx)(o.EuiFieldText,{fullWidth:!0,name:"name",value:e.name,onChange:T,isInvalid:h.hasOwnProperty("name"),"data-test-subj":"cloud-defend-selectorcondition-name",maxLength:ae.f})),A.map((t=>{const n=ce(t),i=te[t].type;return"flag"===i?Object(me.jsx)(he,{key:t,label:n,prop:t,onRemoveCondition:R}):"boolean"===i?Object(me.jsx)(be,{key:t,label:n,selector:e,prop:t,onChangeBooleanCondition:D,onRemoveCondition:R}):Object(me.jsx)(je,{key:t,label:n,prop:t,selector:e,errorMap:h,onAddValueToCondition:P,onChangeStringArrayCondition:_,onRemoveCondition:R})}))),Object(me.jsx)(o.EuiSpacer,{size:"m"}),Object(me.jsx)(o.EuiPopover,{id:"cloudDefendControlAddCondition","data-test-subj":"cloud-defend-addconditionpopover",button:Object(me.jsx)(o.EuiButtonEmpty,{onClick:C,iconType:"plusInCircle","data-test-subj":"cloud-defend-btnaddselectorcondition"},L),isOpen:m,closePopover:I,panelPaddingSize:"none",anchorPosition:"downLeft"},Object(me.jsx)(o.EuiContextMenuPanel,{size:"s",items:M.map((e=>{const t=ce(e),n=function(e,t){const n=te[t];return!!e.find((e=>{var t;return null==n||null===(t=n.not)||void 0===t?void 0:t.includes(e)}))}(A,e);return Object(me.jsx)(o.EuiContextMenuItem,{"data-test-subj":`cloud-defend-addmenu-${e}`,key:e,onClick:()=>N(e),disabled:n},t)}))})));var W},xe=/response_\d+_(.*)/,ye=({response:e,selectors:t,responses:n,index:a,onRemove:s,onDuplicate:l,onChange:u})=>{var d,p,g,f,m;const{euiTheme:{colors:b}}=Object(o.useEuiTheme)(),[h,j]=Object(i.useState)(!1),v=(()=>{const{euiTheme:e}=Object(o.useEuiTheme)(),{border:t,size:n}=e,r=Object(o.useEuiBackgroundColor)("subdued");return Object(i.useMemo)((()=>({options:{position:"absolute",top:n.m,right:n.m},accordion:{borderRadius:t.radius.medium,"> .euiAccordion__triggerWrapper":{padding:n.m},backgroundColor:r},accordionHeader:{"> *":{display:"inline-block",verticalAlign:"middle"},"> b":{marginRight:n.s}}})),[r,t.radius.medium,n.m,n.s])})(),x=fe(),y=Object(o.euiPaletteColorBlindBehindText)(),[O,C]=Object(i.useState)(n.length-1===a?"open":"closed"),I=null===(d=e.actions)||void 0===d?void 0:d.includes("log"),w=null===(p=e.actions)||void 0===p?void 0:p.includes("alert"),M=null===(g=e.actions)||void 0===g?void 0:g.includes("block"),P=Object(i.useMemo)((()=>M&&function(e,t){return!(!t||!t.reduce(((t,n)=>{var i;const r=e.find((e=>e.name===n)),o=ue(r);return t||!(!o||null==r||null===(i=r.targetFilePath)||void 0===i||!i.includes("/**"))}),!1))}(t,e.match)),[M,e.match,t]),z=Object(i.useMemo)((()=>{var n;const i={};if(0===e.match.length&&(i.match=[Z]),0===(null===(n=e.actions)||void 0===n?void 0:n.length)&&(i.actions=[X]),M){const n=pe(t,[e]);n.length>0&&(i.response=n)}return i}),[e,t,M]),L=Object(i.useMemo)((()=>Object.values(z)),[z]),V=Object(i.useCallback)(((e,t)=>{L.length&&(e.hasErrors=!0),u(e,t)}),[L.length,u]);Object(i.useEffect)((()=>{const t=L.length>0;(t&&!e.hasErrors||!t&&e.hasErrors)&&(e.hasErrors=t,u(e,a))}),[L.length,a,u,e]);const q=Object(i.useCallback)((()=>{j(!h)}),[h]),$=Object(i.useCallback)((()=>{j(!1)}),[]),B=Object(i.useCallback)((()=>{s(a),$()}),[$,a,s]),W=Object(i.useCallback)((()=>{l(e),$()}),[$,l,e]),U=Object(i.useCallback)((t=>{e.match=t.map((e=>e.value)),V(e,a)}),[a,V,e]),J=Object(i.useCallback)((t=>{var n;e.exclude=t.map((e=>e.value)),0===(null===(n=e.exclude)||void 0===n?void 0:n.length)&&delete e.exclude,V(e,a)}),[a,V,e]),H=Object(i.useMemo)((()=>t.filter((t=>{var n;return!(t.type!==e.type||e.match.includes(t.name)||null!==(n=e.exclude)&&void 0!==n&&n.includes(t.name))})).map((e=>({label:e.name,value:e.name})))),[e.exclude,e.match,e.type,t]),G=Object(i.useMemo)((()=>e.match.map((e=>({label:e,value:e,color:y[0]})))),[e.match,y]),K=Object(i.useMemo)((()=>e.exclude&&e.exclude.map((e=>({label:e,value:e,color:y[5]})))),[e.exclude,y]),Y=Object(i.useCallback)((()=>{const t={...e};t.exclude=[],V(t,a)}),[a,V,e]),te=Object(i.useCallback)((t=>{var n,i,r;const o=null===(n=t.currentTarget)||void 0===n||null===(i=n.id)||void 0===i||null===(r=i.match(xe))||void 0===r?void 0:r[1],s=JSON.parse(JSON.stringify(e)),c=s.actions.indexOf(o);if(-1===c)s.actions.push(o);else{if("alert"===o){const e=s.actions.indexOf("block");-1!==e&&s.actions.splice(e,1)}s.actions.splice(c,1)}V(s,a)}),[a,V,e]),ne=Object(i.useCallback)((e=>{C(e?"open":"closed")}),[]),{title:ie,plusCount:re,remainingNames:oe}=Object(i.useMemo)((()=>"open"===O?{title:e.match.slice(0,4).join(", "),plusCount:e.match.length-4,remainingNames:e.match.slice(4).join(",")}:{title:e.match.slice(0,2).join(", "),plusCount:e.match.length-2,remainingNames:e.match.slice(2).join(",")}),[O,e.match]);return Object(me.jsx)(o.EuiAccordion,{id:"response_"+a,forceState:O,onToggle:ne,"data-test-subj":`cloud-defend-${e.type}-response`,paddingSize:"m",buttonContent:Object(me.jsx)(o.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},Object(me.jsx)(o.EuiFlexItem,{grow:!1},Object(me.jsx)(o.EuiToolTip,{content:(ae=e.type,"process"===ae?c.i18n.translate("xpack.cloudDefend.processResponseIconTooltip",{defaultMessage:"A process response.\nOnly process selectors can be used to match/exclude."}):c.i18n.translate("xpack.cloudDefend.fileResponseIconTooltip",{defaultMessage:"A file response.\nOnly file selectors can be used to match/exclude."}))},Object(me.jsx)(o.EuiIcon,{color:"primary",type:se(e.type)}))),Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiText,{size:"s",css:v.accordionHeader},Object(me.jsx)("b",null,ie),re>0&&Object(me.jsx)(o.EuiBadge,{title:oe},"+",re)))),css:v.accordion,initialIsOpen:0===a,extraAction:Object(me.jsx)(o.EuiFlexGroup,{alignItems:"center",gutterSize:"none",wrap:!1},"closed"===O&&Object(me.jsx)(o.EuiText,{color:"subdued",css:x.conditionsBadge,size:"xs"},(null==e||null===(f=e.exclude)||void 0===f?void 0:f.length)&&Object(me.jsx)(r.a.Fragment,null,Object(me.jsx)("b",null,F,": "),Object(me.jsx)(o.EuiBadge,{title:e.exclude.join(","),color:"hollow"},e.exclude.length),Object(me.jsx)("div",{css:x.verticalDivider})),Object(me.jsx)("b",null,T,": "),null===(m=e.actions)||void 0===m?void 0:m.map(((t,n)=>{var i;return Object(me.jsx)("span",{key:t},Object(me.jsx)("b",{style:{color:"block"===t?b.danger:b.ink}},t[0].toUpperCase()+t.slice(1)),n!==((null===(i=e.actions)||void 0===i?void 0:i.length)||0)-1&&", ")})),Object(me.jsx)("div",{css:x.verticalDivider})),Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiPopover,{button:Object(me.jsx)(o.EuiButtonIcon,{iconType:"boxesHorizontal",onClick:q,"aria-label":"Response options","data-test-subj":"cloud-defend-btnresponsepopover"}),isOpen:h,closePopover:$,panelPaddingSize:"none",anchorPosition:"downLeft"},Object(me.jsx)(o.EuiContextMenuPanel,{size:"s",items:[Object(me.jsx)(o.EuiContextMenuItem,{key:"duplicate",icon:"copy",onClick:W,"data-test-subj":"cloud-defend-btnduplicateresponse"},k),Object(me.jsx)(o.EuiContextMenuItem,{key:"remove",icon:"trash",disabled:n.length<2,onClick:B,"data-test-subj":"cloud-defend-btndeleteresponse"},E)]}))))},Object(me.jsx)(o.EuiForm,{component:"form",fullWidth:!0,error:L,isInvalid:L.length>0},P&&Object(me.jsx)(o.EuiFormRow,{fullWidth:!0},Object(me.jsx)(o.EuiCallOut,{color:"warning",title:Q},Object(me.jsx)("p",null,ee))),Object(me.jsx)(o.EuiFormRow,{label:A,fullWidth:!0,isInvalid:!!z.match},Object(me.jsx)(o.EuiComboBox,{"aria-label":A,fullWidth:!0,selectedOptions:G,options:H,isClearable:!0,onChange:U,"data-test-subj":"cloud-defend-responsematch"})),e.exclude&&Object(me.jsx)(o.EuiFormRow,{label:S,fullWidth:!0},Object(me.jsx)(o.EuiComboBox,{"aria-label":S,fullWidth:!0,selectedOptions:K,options:H,onChange:J,isClearable:!0,"data-test-subj":"cloud-defend-responseexclude"})),Object(me.jsx)(o.EuiSpacer,{size:"s"}),!e.exclude&&Object(me.jsx)(o.EuiButtonEmpty,{iconType:"plusInCircle",onClick:Y,size:"xs","data-test-subj":"cloud-defend-btnshowexclude"},S),Object(me.jsx)(o.EuiSpacer,{size:"m"}),Object(me.jsx)(o.EuiFormRow,{label:T,fullWidth:!0,isInvalid:!!z.actions},Object(me.jsx)(o.EuiFlexGroup,{direction:"row",gutterSize:"l"},Object(me.jsx)(o.EuiFlexItem,{grow:!1},Object(me.jsx)(o.EuiCheckbox,{id:`response_${a}_log`,"data-test-subj":"cloud-defend-chklogaction",label:_,checked:I,onChange:te})),Object(me.jsx)(o.EuiFlexItem,{grow:!1},Object(me.jsx)(o.EuiCheckbox,{id:`response_${a}_alert`,"data-test-subj":"cloud-defend-chkalertaction",label:D,checked:w,onChange:te})),Object(me.jsx)(o.EuiFlexItem,{grow:!1},Object(me.jsx)(o.EuiToolTip,{content:R},Object(me.jsx)(o.EuiCheckbox,{id:`response_${a}_block`,"data-test-subj":"cloud-defend-chkblockaction",label:N,checked:M,onChange:te,disabled:!w})))))));var ae},Oe=({type:e,onSelectType:t,selectors:n,responses:r})=>{const a=Object(i.useMemo)((()=>le(n,r)),[r,n]),[s,c]=Object(i.useState)(!1),l=()=>{c(!1)},u=Object(i.useCallback)((()=>{l(),t("file")}),[t]),d=Object(i.useCallback)((()=>{l(),t("process")}),[t]),p="Selector"===e,g=[Object(me.jsx)(o.EuiContextMenuItem,{key:`addFile${e}`,icon:"document",onClick:u,disabled:a.file>=ae.e,"data-test-subj":`cloud-defend-btnAddFile${e}`},p?b:v),Object(me.jsx)(o.EuiContextMenuItem,{key:`addProcess${e}`,icon:"gear",onClick:d,disabled:a.process>=ae.e,"data-test-subj":`cloud-defend-btnAddProcess${e}`},p?h:x),Object(me.jsx)(o.EuiContextMenuItem,{key:`addNetwork${e}`,icon:"globe",disabled:!0,"data-test-subj":`cloud-defend-btnAddNetwork${e}`},p?j:y)];return Object(me.jsx)(o.EuiPopover,{id:`btnAdd${e}`,display:"block",button:Object(me.jsx)(o.EuiButton,{fullWidth:!0,color:"primary",iconType:"plusInCircle",onClick:()=>{c(!s)},"data-test-subj":`cloud-defend-btnAdd${e}`},p?z:P),isOpen:s,closePopover:l,panelPaddingSize:"none",anchorPosition:"downLeft"},Object(me.jsx)(o.EuiContextMenuPanel,{size:"s",items:g}))},ke=({policy:e,onChange:t,show:n})=>{var r,c,l;const u=Object(i.useMemo)((()=>({panel:{position:"relative"},draggable:{padding:0,paddingBottom:"12px"},hide:{display:"none"}})),[]),d=Object(s.b)(e,a.b),p=(null==d||null===(r=d.vars)||void 0===r||null===(c=r.configuration)||void 0===c?void 0:c.value)||"",{selectors:g,responses:f}=Object(i.useMemo)((()=>Object(s.c)(p)),[p]),m=Object(i.useCallback)(((n,i)=>{var r;if(null!=d&&null!==(r=d.vars)&&void 0!==r&&r.configuration){const r=!n.find((e=>e.hasErrors))&&!i.find((e=>e.hasErrors));d.vars.configuration.value=Object(s.d)(n,i),t({isValid:r,updatedPolicy:{...e}})}}),[null==d||null===(l=d.vars)||void 0===l?void 0:l.configuration,t,e]),b=Object(i.useCallback)((e=>{const t=e.search(/\d+$/),n=-1!==t?e.slice(0,t)+(parseInt(e.slice(t),10)+1):e+"1",i=g.find((e=>e.name===n));return i?b(i.name):n}),[g]),h=Object(i.useCallback)((e=>{const t=function(e){return"process"===e?JSON.parse(JSON.stringify(ie)):JSON.parse(JSON.stringify(ne))}(e),n=g.find((e=>e.name===t.name));n&&(t.name=b(n.name)),g.push(t),m(g,f)}),[b,m,f,g]),j=Object(i.useCallback)((e=>{const t=function(e){return"process"===e?{...oe}:{...re}}(e);f.push(t),m(g,f)}),[m,f,g]),v=Object(i.useCallback)((e=>{const t=JSON.parse(JSON.stringify(e));t.name=b(t.name),g.push(t),m(g,f)}),[b,m,f,g]),x=Object(i.useCallback)((e=>{const t=g[e].name,n=[...g];n.splice(e,1);const i=f.map((e=>{const n={...e},i=n.match.indexOf(t);if(-1!==i&&n.match.splice(i,1),n.exclude){const e=n.exclude.indexOf(t);-1!==e&&n.exclude.splice(e,1)}return n}));m(n,i)}),[m,f,g]),y=Object(i.useCallback)((e=>{const t={...e};f.push(t),m(g,f)}),[m,f,g]),O=Object(i.useCallback)((e=>{const t=[...f];t.splice(e,1),m(g,t)}),[m,f,g]),k=Object(i.useCallback)(((e,t)=>{const n=g[t];!1===e.hasErrors&&delete e.hasErrors;const i=JSON.parse(JSON.stringify(g));let r=JSON.parse(JSON.stringify(f));n.name!==e.name&&(r=f.map((t=>{let i=t.match.indexOf(n.name);return-1!==i&&(t.match[i]=e.name),t.exclude&&(i=t.exclude.indexOf(n.name),-1!==i&&(t.exclude[i]=e.name)),t}))),i[t]=JSON.parse(JSON.stringify(e)),m(i,r)}),[m,f,g]),E=Object(i.useCallback)(((e,t)=>{!1===e.hasErrors&&delete e.hasErrors;const n=JSON.parse(JSON.stringify(f));n[t]=JSON.parse(JSON.stringify(e)),m(g,n)}),[m,f,g]);return Object(me.jsx)(o.EuiFlexGroup,{css:!n&&u.hide,gutterSize:"m",direction:"column","data-test-subj":"cloud-defend-generalview"},Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiTitle,{size:"xs"},Object(me.jsx)("h4",null,C)),Object(me.jsx)(o.EuiText,{color:"subdued",size:"s"},I)),g.map(((e,t)=>{const n=!!f.find((t=>{var n;return t.match.includes(e.name)||(null==t||null===(n=t.exclude)||void 0===n?void 0:n.includes(e.name))}));return Object(me.jsx)(o.EuiFlexItem,{key:t},Object(me.jsx)(ve,{key:t,index:t,selector:e,selectors:g,usedByResponse:n,onDuplicate:v,onRemove:x,onChange:k}))})),Object(me.jsx)(Oe,{type:"Selector",onSelectType:h,selectors:g,responses:f}),Object(me.jsx)(o.EuiSpacer,{size:"m"}),Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiTitle,{size:"xs"},Object(me.jsx)("h4",null,w)),Object(me.jsx)(o.EuiText,{size:"s",color:"subdued"},M)),f.map(((e,t)=>Object(me.jsx)(o.EuiFlexItem,{key:t},Object(me.jsx)(ye,{index:t,response:e,responses:f,selectors:g,onRemove:O,onDuplicate:y,onChange:E})))),Object(me.jsx)(Oe,{type:"Response",onSelectType:j,selectors:g,responses:f}),Object(me.jsx)(o.EuiSpacer,{size:"m"}))};var Ee,Ce,Ie,we,Me,Ae,Se,Fe,Te,_e,De,Ne,Re,Pe,ze,Le,Ve,qe,$e,Be,We,Ue,Je,He,Ge,Ke,Ze,Xe,Ye=n(9),Qe=n(28),et=n(23);!function(e){e.is=function(e){return"string"==typeof e}}(Ee||(Ee={})),function(e){e.is=function(e){return"string"==typeof e}}(Ce||(Ce={})),function(e){e.MIN_VALUE=-2147483648,e.MAX_VALUE=2147483647,e.is=function(t){return"number"==typeof t&&e.MIN_VALUE<=t&&t<=e.MAX_VALUE}}(Ie||(Ie={})),function(e){e.MIN_VALUE=0,e.MAX_VALUE=2147483647,e.is=function(t){return"number"==typeof t&&e.MIN_VALUE<=t&&t<=e.MAX_VALUE}}(we||(we={})),function(e){e.create=function(e,t){return e===Number.MAX_VALUE&&(e=we.MAX_VALUE),t===Number.MAX_VALUE&&(t=we.MAX_VALUE),{line:e,character:t}},e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Gt.uinteger(t.line)&&Gt.uinteger(t.character)}}(Me||(Me={})),function(e){e.create=function(e,t,n,i){if(Gt.uinteger(e)&&Gt.uinteger(t)&&Gt.uinteger(n)&&Gt.uinteger(i))return{start:Me.create(e,t),end:Me.create(n,i)};if(Me.is(e)&&Me.is(t))return{start:e,end:t};throw new Error("Range#create called with invalid arguments[".concat(e,", ").concat(t,", ").concat(n,", ").concat(i,"]"))},e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Me.is(t.start)&&Me.is(t.end)}}(Ae||(Ae={})),function(e){e.create=function(e,t){return{uri:e,range:t}},e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Ae.is(t.range)&&(Gt.string(t.uri)||Gt.undefined(t.uri))}}(Se||(Se={})),function(e){e.create=function(e,t,n,i){return{targetUri:e,targetRange:t,targetSelectionRange:n,originSelectionRange:i}},e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Ae.is(t.targetRange)&&Gt.string(t.targetUri)&&Ae.is(t.targetSelectionRange)&&(Ae.is(t.originSelectionRange)||Gt.undefined(t.originSelectionRange))}}(Fe||(Fe={})),function(e){e.create=function(e,t,n,i){return{red:e,green:t,blue:n,alpha:i}},e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Gt.numberRange(t.red,0,1)&&Gt.numberRange(t.green,0,1)&&Gt.numberRange(t.blue,0,1)&&Gt.numberRange(t.alpha,0,1)}}(Te||(Te={})),function(e){e.create=function(e,t){return{range:e,color:t}},e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Ae.is(t.range)&&Te.is(t.color)}}(_e||(_e={})),function(e){e.create=function(e,t,n){return{label:e,textEdit:t,additionalTextEdits:n}},e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Gt.string(t.label)&&(Gt.undefined(t.textEdit)||Be.is(t))&&(Gt.undefined(t.additionalTextEdits)||Gt.typedArray(t.additionalTextEdits,Be.is))}}(De||(De={})),function(e){e.Comment="comment",e.Imports="imports",e.Region="region"}(Ne||(Ne={})),function(e){e.create=function(e,t,n,i,r,o){var a={startLine:e,endLine:t};return Gt.defined(n)&&(a.startCharacter=n),Gt.defined(i)&&(a.endCharacter=i),Gt.defined(r)&&(a.kind=r),Gt.defined(o)&&(a.collapsedText=o),a},e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Gt.uinteger(t.startLine)&&Gt.uinteger(t.startLine)&&(Gt.undefined(t.startCharacter)||Gt.uinteger(t.startCharacter))&&(Gt.undefined(t.endCharacter)||Gt.uinteger(t.endCharacter))&&(Gt.undefined(t.kind)||Gt.string(t.kind))}}(Re||(Re={})),function(e){e.create=function(e,t){return{location:e,message:t}},e.is=function(e){var t=e;return Gt.defined(t)&&Se.is(t.location)&&Gt.string(t.message)}}(Pe||(Pe={})),function(e){e.Error=1,e.Warning=2,e.Information=3,e.Hint=4}(ze||(ze={})),function(e){e.Unnecessary=1,e.Deprecated=2}(Le||(Le={})),function(e){e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Gt.string(t.href)}}(Ve||(Ve={})),function(e){e.create=function(e,t,n,i,r,o){var a={range:e,message:t};return Gt.defined(n)&&(a.severity=n),Gt.defined(i)&&(a.code=i),Gt.defined(r)&&(a.source=r),Gt.defined(o)&&(a.relatedInformation=o),a},e.is=function(e){var t,n=e;return Gt.defined(n)&&Ae.is(n.range)&&Gt.string(n.message)&&(Gt.number(n.severity)||Gt.undefined(n.severity))&&(Gt.integer(n.code)||Gt.string(n.code)||Gt.undefined(n.code))&&(Gt.undefined(n.codeDescription)||Gt.string(null===(t=n.codeDescription)||void 0===t?void 0:t.href))&&(Gt.string(n.source)||Gt.undefined(n.source))&&(Gt.undefined(n.relatedInformation)||Gt.typedArray(n.relatedInformation,Pe.is))}}(qe||(qe={})),function(e){e.create=function(e,t){for(var n=[],i=2;i<arguments.length;i++)n[i-2]=arguments[i];var r={title:e,command:t};return Gt.defined(n)&&n.length>0&&(r.arguments=n),r},e.is=function(e){var t=e;return Gt.defined(t)&&Gt.string(t.title)&&Gt.string(t.command)}}($e||($e={})),function(e){e.replace=function(e,t){return{range:e,newText:t}},e.insert=function(e,t){return{range:{start:e,end:e},newText:t}},e.del=function(e){return{range:e,newText:""}},e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Gt.string(t.newText)&&Ae.is(t.range)}}(Be||(Be={})),function(e){e.create=function(e,t,n){var i={label:e};return void 0!==t&&(i.needsConfirmation=t),void 0!==n&&(i.description=n),i},e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Gt.string(t.label)&&(Gt.boolean(t.needsConfirmation)||void 0===t.needsConfirmation)&&(Gt.string(t.description)||void 0===t.description)}}(We||(We={})),function(e){e.is=function(e){var t=e;return Gt.string(t)}}(Ue||(Ue={})),function(e){e.replace=function(e,t,n){return{range:e,newText:t,annotationId:n}},e.insert=function(e,t,n){return{range:{start:e,end:e},newText:t,annotationId:n}},e.del=function(e,t){return{range:e,newText:"",annotationId:t}},e.is=function(e){var t=e;return Be.is(t)&&(We.is(t.annotationId)||Ue.is(t.annotationId))}}(Je||(Je={})),function(e){e.create=function(e,t){return{textDocument:e,edits:t}},e.is=function(e){var t=e;return Gt.defined(t)&&it.is(t.textDocument)&&Array.isArray(t.edits)}}(He||(He={})),function(e){e.create=function(e,t,n){var i={kind:"create",uri:e};return void 0===t||void 0===t.overwrite&&void 0===t.ignoreIfExists||(i.options=t),void 0!==n&&(i.annotationId=n),i},e.is=function(e){var t=e;return t&&"create"===t.kind&&Gt.string(t.uri)&&(void 0===t.options||(void 0===t.options.overwrite||Gt.boolean(t.options.overwrite))&&(void 0===t.options.ignoreIfExists||Gt.boolean(t.options.ignoreIfExists)))&&(void 0===t.annotationId||Ue.is(t.annotationId))}}(Ge||(Ge={})),function(e){e.create=function(e,t,n,i){var r={kind:"rename",oldUri:e,newUri:t};return void 0===n||void 0===n.overwrite&&void 0===n.ignoreIfExists||(r.options=n),void 0!==i&&(r.annotationId=i),r},e.is=function(e){var t=e;return t&&"rename"===t.kind&&Gt.string(t.oldUri)&&Gt.string(t.newUri)&&(void 0===t.options||(void 0===t.options.overwrite||Gt.boolean(t.options.overwrite))&&(void 0===t.options.ignoreIfExists||Gt.boolean(t.options.ignoreIfExists)))&&(void 0===t.annotationId||Ue.is(t.annotationId))}}(Ke||(Ke={})),function(e){e.create=function(e,t,n){var i={kind:"delete",uri:e};return void 0===t||void 0===t.recursive&&void 0===t.ignoreIfNotExists||(i.options=t),void 0!==n&&(i.annotationId=n),i},e.is=function(e){var t=e;return t&&"delete"===t.kind&&Gt.string(t.uri)&&(void 0===t.options||(void 0===t.options.recursive||Gt.boolean(t.options.recursive))&&(void 0===t.options.ignoreIfNotExists||Gt.boolean(t.options.ignoreIfNotExists)))&&(void 0===t.annotationId||Ue.is(t.annotationId))}}(Ze||(Ze={})),function(e){e.is=function(e){var t=e;return t&&(void 0!==t.changes||void 0!==t.documentChanges)&&(void 0===t.documentChanges||t.documentChanges.every((function(e){return Gt.string(e.kind)?Ge.is(e)||Ke.is(e)||Ze.is(e):He.is(e)})))}}(Xe||(Xe={}));var tt,nt,it,rt,ot,at,st,ct,lt,ut,dt,pt,gt,ft,mt,bt,ht,jt,vt,xt,yt,Ot,kt,Et,Ct,It,wt,Mt,At,St,Ft,Tt,_t,Dt,Nt,Rt,Pt,zt,Lt,Vt,qt,$t,Bt,Wt,Ut,Jt=function(){function e(e,t){this.edits=e,this.changeAnnotations=t}return e.prototype.insert=function(e,t,n){var i,r;if(void 0===n?i=Be.insert(e,t):Ue.is(n)?(r=n,i=Je.insert(e,t,n)):(this.assertChangeAnnotations(this.changeAnnotations),r=this.changeAnnotations.manage(n),i=Je.insert(e,t,r)),this.edits.push(i),void 0!==r)return r},e.prototype.replace=function(e,t,n){var i,r;if(void 0===n?i=Be.replace(e,t):Ue.is(n)?(r=n,i=Je.replace(e,t,n)):(this.assertChangeAnnotations(this.changeAnnotations),r=this.changeAnnotations.manage(n),i=Je.replace(e,t,r)),this.edits.push(i),void 0!==r)return r},e.prototype.delete=function(e,t){var n,i;if(void 0===t?n=Be.del(e):Ue.is(t)?(i=t,n=Je.del(e,t)):(this.assertChangeAnnotations(this.changeAnnotations),i=this.changeAnnotations.manage(t),n=Je.del(e,i)),this.edits.push(n),void 0!==i)return i},e.prototype.add=function(e){this.edits.push(e)},e.prototype.all=function(){return this.edits},e.prototype.clear=function(){this.edits.splice(0,this.edits.length)},e.prototype.assertChangeAnnotations=function(e){if(void 0===e)throw new Error("Text edit change is not configured to manage change annotations.")},e}(),Ht=function(){function e(e){this._annotations=void 0===e?Object.create(null):e,this._counter=0,this._size=0}return e.prototype.all=function(){return this._annotations},Object.defineProperty(e.prototype,"size",{get:function(){return this._size},enumerable:!1,configurable:!0}),e.prototype.manage=function(e,t){var n;if(Ue.is(e)?n=e:(n=this.nextId(),t=e),void 0!==this._annotations[n])throw new Error("Id ".concat(n," is already in use."));if(void 0===t)throw new Error("No annotation provided for id ".concat(n));return this._annotations[n]=t,this._size++,n},e.prototype.nextId=function(){return this._counter++,this._counter.toString()},e}();!function(){function e(e){var t=this;this._textEditChanges=Object.create(null),void 0!==e?(this._workspaceEdit=e,e.documentChanges?(this._changeAnnotations=new Ht(e.changeAnnotations),e.changeAnnotations=this._changeAnnotations.all(),e.documentChanges.forEach((function(e){if(He.is(e)){var n=new Jt(e.edits,t._changeAnnotations);t._textEditChanges[e.textDocument.uri]=n}}))):e.changes&&Object.keys(e.changes).forEach((function(n){var i=new Jt(e.changes[n]);t._textEditChanges[n]=i}))):this._workspaceEdit={}}Object.defineProperty(e.prototype,"edit",{get:function(){return this.initDocumentChanges(),void 0!==this._changeAnnotations&&(0===this._changeAnnotations.size?this._workspaceEdit.changeAnnotations=void 0:this._workspaceEdit.changeAnnotations=this._changeAnnotations.all()),this._workspaceEdit},enumerable:!1,configurable:!0}),e.prototype.getTextEditChange=function(e){if(it.is(e)){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var t={uri:e.uri,version:e.version};if(!(i=this._textEditChanges[t.uri])){var n={textDocument:t,edits:r=[]};this._workspaceEdit.documentChanges.push(n),i=new Jt(r,this._changeAnnotations),this._textEditChanges[t.uri]=i}return i}if(this.initChanges(),void 0===this._workspaceEdit.changes)throw new Error("Workspace edit is not configured for normal text edit changes.");var i;if(!(i=this._textEditChanges[e])){var r=[];this._workspaceEdit.changes[e]=r,i=new Jt(r),this._textEditChanges[e]=i}return i},e.prototype.initDocumentChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._changeAnnotations=new Ht,this._workspaceEdit.documentChanges=[],this._workspaceEdit.changeAnnotations=this._changeAnnotations.all())},e.prototype.initChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._workspaceEdit.changes=Object.create(null))},e.prototype.createFile=function(e,t,n){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var i,r,o;if(We.is(t)||Ue.is(t)?i=t:n=t,void 0===i?r=Ge.create(e,n):(o=Ue.is(i)?i:this._changeAnnotations.manage(i),r=Ge.create(e,n,o)),this._workspaceEdit.documentChanges.push(r),void 0!==o)return o},e.prototype.renameFile=function(e,t,n,i){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var r,o,a;if(We.is(n)||Ue.is(n)?r=n:i=n,void 0===r?o=Ke.create(e,t,i):(a=Ue.is(r)?r:this._changeAnnotations.manage(r),o=Ke.create(e,t,i,a)),this._workspaceEdit.documentChanges.push(o),void 0!==a)return a},e.prototype.deleteFile=function(e,t,n){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var i,r,o;if(We.is(t)||Ue.is(t)?i=t:n=t,void 0===i?r=Ze.create(e,n):(o=Ue.is(i)?i:this._changeAnnotations.manage(i),r=Ze.create(e,n,o)),this._workspaceEdit.documentChanges.push(r),void 0!==o)return o}}(),function(e){e.create=function(e){return{uri:e}},e.is=function(e){var t=e;return Gt.defined(t)&&Gt.string(t.uri)}}(tt||(tt={})),function(e){e.create=function(e,t){return{uri:e,version:t}},e.is=function(e){var t=e;return Gt.defined(t)&&Gt.string(t.uri)&&Gt.integer(t.version)}}(nt||(nt={})),function(e){e.create=function(e,t){return{uri:e,version:t}},e.is=function(e){var t=e;return Gt.defined(t)&&Gt.string(t.uri)&&(null===t.version||Gt.integer(t.version))}}(it||(it={})),function(e){e.create=function(e,t,n,i){return{uri:e,languageId:t,version:n,text:i}},e.is=function(e){var t=e;return Gt.defined(t)&&Gt.string(t.uri)&&Gt.string(t.languageId)&&Gt.integer(t.version)&&Gt.string(t.text)}}(rt||(rt={})),function(e){e.PlainText="plaintext",e.Markdown="markdown",e.is=function(t){var n=t;return n===e.PlainText||n===e.Markdown}}(ot||(ot={})),function(e){e.is=function(e){var t=e;return Gt.objectLiteral(e)&&ot.is(t.kind)&&Gt.string(t.value)}}(at||(at={})),function(e){e.Text=1,e.Method=2,e.Function=3,e.Constructor=4,e.Field=5,e.Variable=6,e.Class=7,e.Interface=8,e.Module=9,e.Property=10,e.Unit=11,e.Value=12,e.Enum=13,e.Keyword=14,e.Snippet=15,e.Color=16,e.File=17,e.Reference=18,e.Folder=19,e.EnumMember=20,e.Constant=21,e.Struct=22,e.Event=23,e.Operator=24,e.TypeParameter=25}(st||(st={})),function(e){e.PlainText=1,e.Snippet=2}(ct||(ct={})),function(e){e.Deprecated=1}(lt||(lt={})),function(e){e.create=function(e,t,n){return{newText:e,insert:t,replace:n}},e.is=function(e){var t=e;return t&&Gt.string(t.newText)&&Ae.is(t.insert)&&Ae.is(t.replace)}}(ut||(ut={})),function(e){e.asIs=1,e.adjustIndentation=2}(dt||(dt={})),function(e){e.is=function(e){var t=e;return t&&(Gt.string(t.detail)||void 0===t.detail)&&(Gt.string(t.description)||void 0===t.description)}}(pt||(pt={})),function(e){e.create=function(e){return{label:e}}}(gt||(gt={})),function(e){e.create=function(e,t){return{items:e||[],isIncomplete:!!t}}}(ft||(ft={})),function(e){e.fromPlainText=function(e){return e.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")},e.is=function(e){var t=e;return Gt.string(t)||Gt.objectLiteral(t)&&Gt.string(t.language)&&Gt.string(t.value)}}(mt||(mt={})),function(e){e.is=function(e){var t=e;return!!t&&Gt.objectLiteral(t)&&(at.is(t.contents)||mt.is(t.contents)||Gt.typedArray(t.contents,mt.is))&&(void 0===e.range||Ae.is(e.range))}}(bt||(bt={})),function(e){e.create=function(e,t){return t?{label:e,documentation:t}:{label:e}}}(ht||(ht={})),function(e){e.create=function(e,t){for(var n=[],i=2;i<arguments.length;i++)n[i-2]=arguments[i];var r={label:e};return Gt.defined(t)&&(r.documentation=t),Gt.defined(n)?r.parameters=n:r.parameters=[],r}}(jt||(jt={})),function(e){e.Text=1,e.Read=2,e.Write=3}(vt||(vt={})),function(e){e.create=function(e,t){var n={range:e};return Gt.number(t)&&(n.kind=t),n}}(xt||(xt={})),function(e){e.File=1,e.Module=2,e.Namespace=3,e.Package=4,e.Class=5,e.Method=6,e.Property=7,e.Field=8,e.Constructor=9,e.Enum=10,e.Interface=11,e.Function=12,e.Variable=13,e.Constant=14,e.String=15,e.Number=16,e.Boolean=17,e.Array=18,e.Object=19,e.Key=20,e.Null=21,e.EnumMember=22,e.Struct=23,e.Event=24,e.Operator=25,e.TypeParameter=26}(yt||(yt={})),function(e){e.Deprecated=1}(Ot||(Ot={})),function(e){e.create=function(e,t,n,i,r){var o={name:e,kind:t,location:{uri:i,range:n}};return r&&(o.containerName=r),o}}(kt||(kt={})),function(e){e.create=function(e,t,n,i){return void 0!==i?{name:e,kind:t,location:{uri:n,range:i}}:{name:e,kind:t,location:{uri:n}}}}(Et||(Et={})),function(e){e.create=function(e,t,n,i,r,o){var a={name:e,detail:t,kind:n,range:i,selectionRange:r};return void 0!==o&&(a.children=o),a},e.is=function(e){var t=e;return t&&Gt.string(t.name)&&Gt.number(t.kind)&&Ae.is(t.range)&&Ae.is(t.selectionRange)&&(void 0===t.detail||Gt.string(t.detail))&&(void 0===t.deprecated||Gt.boolean(t.deprecated))&&(void 0===t.children||Array.isArray(t.children))&&(void 0===t.tags||Array.isArray(t.tags))}}(Ct||(Ct={})),function(e){e.Empty="",e.QuickFix="quickfix",e.Refactor="refactor",e.RefactorExtract="refactor.extract",e.RefactorInline="refactor.inline",e.RefactorRewrite="refactor.rewrite",e.Source="source",e.SourceOrganizeImports="source.organizeImports",e.SourceFixAll="source.fixAll"}(It||(It={})),function(e){e.Invoked=1,e.Automatic=2}(wt||(wt={})),function(e){e.create=function(e,t,n){var i={diagnostics:e};return null!=t&&(i.only=t),null!=n&&(i.triggerKind=n),i},e.is=function(e){var t=e;return Gt.defined(t)&&Gt.typedArray(t.diagnostics,qe.is)&&(void 0===t.only||Gt.typedArray(t.only,Gt.string))&&(void 0===t.triggerKind||t.triggerKind===wt.Invoked||t.triggerKind===wt.Automatic)}}(Mt||(Mt={})),function(e){e.create=function(e,t,n){var i={title:e},r=!0;return"string"==typeof t?(r=!1,i.kind=t):$e.is(t)?i.command=t:i.edit=t,r&&void 0!==n&&(i.kind=n),i},e.is=function(e){var t=e;return t&&Gt.string(t.title)&&(void 0===t.diagnostics||Gt.typedArray(t.diagnostics,qe.is))&&(void 0===t.kind||Gt.string(t.kind))&&(void 0!==t.edit||void 0!==t.command)&&(void 0===t.command||$e.is(t.command))&&(void 0===t.isPreferred||Gt.boolean(t.isPreferred))&&(void 0===t.edit||Xe.is(t.edit))}}(At||(At={})),function(e){e.create=function(e,t){var n={range:e};return Gt.defined(t)&&(n.data=t),n},e.is=function(e){var t=e;return Gt.defined(t)&&Ae.is(t.range)&&(Gt.undefined(t.command)||$e.is(t.command))}}(St||(St={})),function(e){e.create=function(e,t){return{tabSize:e,insertSpaces:t}},e.is=function(e){var t=e;return Gt.defined(t)&&Gt.uinteger(t.tabSize)&&Gt.boolean(t.insertSpaces)}}(Ft||(Ft={})),function(e){e.create=function(e,t,n){return{range:e,target:t,data:n}},e.is=function(e){var t=e;return Gt.defined(t)&&Ae.is(t.range)&&(Gt.undefined(t.target)||Gt.string(t.target))}}(Tt||(Tt={})),function(e){e.create=function(e,t){return{range:e,parent:t}},e.is=function(t){var n=t;return Gt.objectLiteral(n)&&Ae.is(n.range)&&(void 0===n.parent||e.is(n.parent))}}(_t||(_t={})),function(e){e.namespace="namespace",e.type="type",e.class="class",e.enum="enum",e.interface="interface",e.struct="struct",e.typeParameter="typeParameter",e.parameter="parameter",e.variable="variable",e.property="property",e.enumMember="enumMember",e.event="event",e.function="function",e.method="method",e.macro="macro",e.keyword="keyword",e.modifier="modifier",e.comment="comment",e.string="string",e.number="number",e.regexp="regexp",e.operator="operator",e.decorator="decorator"}(Dt||(Dt={})),function(e){e.declaration="declaration",e.definition="definition",e.readonly="readonly",e.static="static",e.deprecated="deprecated",e.abstract="abstract",e.async="async",e.modification="modification",e.documentation="documentation",e.defaultLibrary="defaultLibrary"}(Nt||(Nt={})),function(e){e.is=function(e){var t=e;return Gt.objectLiteral(t)&&(void 0===t.resultId||"string"==typeof t.resultId)&&Array.isArray(t.data)&&(0===t.data.length||"number"==typeof t.data[0])}}(Rt||(Rt={})),function(e){e.create=function(e,t){return{range:e,text:t}},e.is=function(e){var t=e;return null!=t&&Ae.is(t.range)&&Gt.string(t.text)}}(Pt||(Pt={})),function(e){e.create=function(e,t,n){return{range:e,variableName:t,caseSensitiveLookup:n}},e.is=function(e){var t=e;return null!=t&&Ae.is(t.range)&&Gt.boolean(t.caseSensitiveLookup)&&(Gt.string(t.variableName)||void 0===t.variableName)}}(zt||(zt={})),function(e){e.create=function(e,t){return{range:e,expression:t}},e.is=function(e){var t=e;return null!=t&&Ae.is(t.range)&&(Gt.string(t.expression)||void 0===t.expression)}}(Lt||(Lt={})),function(e){e.create=function(e,t){return{frameId:e,stoppedLocation:t}},e.is=function(e){var t=e;return Gt.defined(t)&&Ae.is(e.stoppedLocation)}}(Vt||(Vt={})),function(e){e.Type=1,e.Parameter=2,e.is=function(e){return 1===e||2===e}}(qt||(qt={})),function(e){e.create=function(e){return{value:e}},e.is=function(e){var t=e;return Gt.objectLiteral(t)&&(void 0===t.tooltip||Gt.string(t.tooltip)||at.is(t.tooltip))&&(void 0===t.location||Se.is(t.location))&&(void 0===t.command||$e.is(t.command))}}($t||($t={})),function(e){e.create=function(e,t,n){var i={position:e,label:t};return void 0!==n&&(i.kind=n),i},e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Me.is(t.position)&&(Gt.string(t.label)||Gt.typedArray(t.label,$t.is))&&(void 0===t.kind||qt.is(t.kind))&&void 0===t.textEdits||Gt.typedArray(t.textEdits,Be.is)&&(void 0===t.tooltip||Gt.string(t.tooltip)||at.is(t.tooltip))&&(void 0===t.paddingLeft||Gt.boolean(t.paddingLeft))&&(void 0===t.paddingRight||Gt.boolean(t.paddingRight))}}(Bt||(Bt={})),function(e){e.is=function(e){var t=e;return Gt.objectLiteral(t)&&Ce.is(t.uri)&&Gt.string(t.name)}}(Wt||(Wt={})),function(e){function t(e,n){if(e.length<=1)return e;var i=e.length/2|0,r=e.slice(0,i),o=e.slice(i);t(r,n),t(o,n);for(var a=0,s=0,c=0;a<r.length&&s<o.length;){var l=n(r[a],o[s]);e[c++]=l<=0?r[a++]:o[s++]}for(;a<r.length;)e[c++]=r[a++];for(;s<o.length;)e[c++]=o[s++];return e}e.create=function(e,t,n,i){return new Kt(e,t,n,i)},e.is=function(e){var t=e;return!!(Gt.defined(t)&&Gt.string(t.uri)&&(Gt.undefined(t.languageId)||Gt.string(t.languageId))&&Gt.uinteger(t.lineCount)&&Gt.func(t.getText)&&Gt.func(t.positionAt)&&Gt.func(t.offsetAt))},e.applyEdits=function(e,n){for(var i=e.getText(),r=t(n,(function(e,t){var n=e.range.start.line-t.range.start.line;return 0===n?e.range.start.character-t.range.start.character:n})),o=i.length,a=r.length-1;a>=0;a--){var s=r[a],c=e.offsetAt(s.range.start),l=e.offsetAt(s.range.end);if(!(l<=o))throw new Error("Overlapping edit");i=i.substring(0,c)+s.newText+i.substring(l,i.length),o=c}return i}}(Ut||(Ut={}));var Gt,Kt=function(){function e(e,t,n,i){this._uri=e,this._languageId=t,this._version=n,this._content=i,this._lineOffsets=void 0}return Object.defineProperty(e.prototype,"uri",{get:function(){return this._uri},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"languageId",{get:function(){return this._languageId},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"version",{get:function(){return this._version},enumerable:!1,configurable:!0}),e.prototype.getText=function(e){if(e){var t=this.offsetAt(e.start),n=this.offsetAt(e.end);return this._content.substring(t,n)}return this._content},e.prototype.update=function(e,t){this._content=e.text,this._version=t,this._lineOffsets=void 0},e.prototype.getLineOffsets=function(){if(void 0===this._lineOffsets){for(var e=[],t=this._content,n=!0,i=0;i<t.length;i++){n&&(e.push(i),n=!1);var r=t.charAt(i);n="\r"===r||"\n"===r,"\r"===r&&i+1<t.length&&"\n"===t.charAt(i+1)&&i++}n&&t.length>0&&e.push(t.length),this._lineOffsets=e}return this._lineOffsets},e.prototype.positionAt=function(e){e=Math.max(Math.min(e,this._content.length),0);var t=this.getLineOffsets(),n=0,i=t.length;if(0===i)return Me.create(0,e);for(;n<i;){var r=Math.floor((n+i)/2);t[r]>e?i=r:n=r+1}var o=n-1;return Me.create(o,e-t[o])},e.prototype.offsetAt=function(e){var t=this.getLineOffsets();if(e.line>=t.length)return this._content.length;if(e.line<0)return 0;var n=t[e.line],i=e.line+1<t.length?t[e.line+1]:this._content.length;return Math.max(Math.min(n+e.character,i),n)},Object.defineProperty(e.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:!1,configurable:!0}),e}();function Zt(e){switch(e){case ze.Error:return et.MarkerSeverity.Error;case ze.Warning:return et.MarkerSeverity.Warning;case ze.Information:return et.MarkerSeverity.Info;case ze.Hint:return et.MarkerSeverity.Hint;default:return et.MarkerSeverity.Info}}function Xt(e){return{severity:Zt(e.severity),startLineNumber:e.range.start.line+1,startColumn:e.range.start.character+1,endLineNumber:e.range.end.line+1,endColumn:e.range.end.character+1,message:e.message,code:String(e.code),source:e.source}}function Yt(e){if(e)return{character:e.column-1,line:e.lineNumber-1}}function Qt(e){if(e)return new et.Range(e.start.line+1,e.start.character+1,e.end.line+1,e.end.character+1)}function en(e){const t=et.languages.CompletionItemKind;switch(e){case st.Text:return t.Text;case st.Method:return t.Method;case st.Function:return t.Function;case st.Constructor:return t.Constructor;case st.Field:return t.Field;case st.Variable:return t.Variable;case st.Class:return t.Class;case st.Interface:return t.Interface;case st.Module:return t.Module;case st.Property:return t.Property;case st.Unit:return t.Unit;case st.Value:return t.Value;case st.Enum:return t.Enum;case st.Keyword:return t.Keyword;case st.Snippet:return t.Snippet;case st.Color:return t.Color;case st.File:return t.File;case st.Reference:return t.Reference;default:return t.Property}}function tn(e){if(e)return{range:Qt(e.range),text:e.newText}}function nn(e){return"string"==typeof e?{value:e}:(t=e)&&"object"==typeof t&&"string"==typeof t.kind?"plaintext"===e.kind?{value:e.value.replace(/[!#()*+.[\\\]_`{}-]/g,"\\$&")}:{value:e.value}:{value:`\`\`\`${e.language}\n${e.value}\n\`\`\`\n`};var t}function rn(e){if(e)return Array.isArray(e)?e.map(nn):[nn(e)]}function on(e){const t=et.languages.SymbolKind;switch(e){case yt.File:return t.Array;case yt.Module:return t.Module;case yt.Namespace:return t.Namespace;case yt.Package:return t.Package;case yt.Class:return t.Class;case yt.Method:return t.Method;case yt.Property:return t.Property;case yt.Field:return t.Field;case yt.Constructor:return t.Constructor;case yt.Enum:return t.Enum;case yt.Interface:return t.Interface;case yt.Function:return t.Function;case yt.Variable:return t.Variable;case yt.Constant:return t.Constant;case yt.String:return t.String;case yt.Number:return t.Number;case yt.Boolean:return t.Boolean;case yt.Array:return t.Array;default:return t.Function}}function an(e){return{detail:"",range:Qt(e.range),name:e.name,kind:on(e.kind),selectionRange:Qt(e.selectionRange),children:e.children.map(an),tags:[]}}function sn(e){return{range:Qt(e.range),tooltip:e.tooltip,url:e.target}}!function(e){var t=Object.prototype.toString;e.defined=function(e){return void 0!==e},e.undefined=function(e){return void 0===e},e.boolean=function(e){return!0===e||!1===e},e.string=function(e){return"[object String]"===t.call(e)},e.number=function(e){return"[object Number]"===t.call(e)},e.numberRange=function(e,n,i){return"[object Number]"===t.call(e)&&n<=e&&e<=i},e.integer=function(e){return"[object Number]"===t.call(e)&&-2147483648<=e&&e<=2147483647},e.uinteger=function(e){return"[object Number]"===t.call(e)&&0<=e&&e<=2147483647},e.func=function(e){return"[object Function]"===t.call(e)},e.objectLiteral=function(e){return null!==e&&"object"==typeof e},e.typedArray=function(e,t){return Array.isArray(e)&&e.every(t)}}(Gt||(Gt={}));var cn=12e4;var ln={comments:{lineComment:"#"},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],onEnterRules:[{beforeText:/:\s*$/,action:{indentAction:et.languages.IndentAction.Indent}}]};function un(e){const t=function(e){let t,n,i=0;const r=()=>{t&&(t.dispose(),t=void 0),n=void 0};return setInterval((()=>{t&&Date.now()-i>cn&&r()}),3e4),e.onDidChange((()=>r())),async(...r)=>{const o=await(i=Date.now(),n||(t=et.editor.createWebWorker({moduleId:"vs/language/yaml/yamlWorker",label:e.languageId,createData:{languageSettings:e.diagnosticsOptions,languageId:e.languageId,enableSchemaRequest:e.diagnosticsOptions.enableSchemaRequest,prefix:e.diagnosticsOptions.prefix,isKubernetes:e.diagnosticsOptions.isKubernetes,customTags:e.diagnosticsOptions.customTags}}),n=t.getProxy()),n);return await t.withSyncedResources(r),o}}(e),{languageId:n}=e;var i;et.languages.registerCompletionItemProvider(n,(i=t,{triggerCharacters:[" ",":"],async provideCompletionItems(e,t){const n=e.uri,r=await i(n),o=await r.doComplete(String(n),Yt(t));if(!o)return;const a=e.getWordUntilPosition(t),s=new et.Range(t.lineNumber,a.startColumn,t.lineNumber,a.endColumn),c=o.items.map((e=>{const t={label:e.label,insertText:e.insertText||e.label,sortText:e.sortText,filterText:e.filterText,documentation:e.documentation,detail:e.detail,kind:en(e.kind),range:s};return e.textEdit&&(t.range=Qt("range"in e.textEdit?e.textEdit.range:e.textEdit.replace),t.insertText=e.textEdit.newText),e.additionalTextEdits&&(t.additionalTextEdits=e.additionalTextEdits.map(tn)),e.insertTextFormat===ct.Snippet&&(t.insertTextRules=et.languages.CompletionItemInsertTextRule.InsertAsSnippet),t}));return{incomplete:o.isIncomplete,suggestions:c}}})),et.languages.registerHoverProvider(n,function(e){return{async provideHover(t,n){const i=t.uri,r=await e(i),o=await r.doHover(String(i),Yt(n));if(o)return{range:Qt(o.range),contents:rn(o.contents)}}}}(t)),et.languages.registerDocumentSymbolProvider(n,function(e){return{async provideDocumentSymbols(t){const n=t.uri,i=await e(n),r=await i.findDocumentSymbols(String(n));if(r)return r.map(an)}}}(t)),et.languages.registerDocumentFormattingEditProvider(n,function(e){return{async provideDocumentFormattingEdits(t,n){const i=t.uri,r=await e(i),o=await r.format(String(i),function(e){return{tabSize:e.tabSize,insertSpaces:e.insertSpaces,...e}}(n));if(o&&0!==o.length)return o.map(tn)}}}(t)),et.languages.registerLinkProvider(n,function(e){return{async provideLinks(t){const n=t.uri,i=await e(n);return{links:(await i.findLinks(String(n))).map(sn)}}}}(t)),function(e,t,n){const i=new Map,r=async e=>{(await t()).resetSchema(String(e))},o=async(e,n)=>{const i=await t(e),r=(await i.doValidation(String(e))).map(Xt),o=et.editor.getModel(e);o&&o.getModeId()===n&&et.editor.setModelMarkers(o,n,r)},a=t=>{const n=t.getModeId();if(n!==e)return;let r;i.set(String(t.uri),t.onDidChangeContent((()=>{clearTimeout(r),r=setTimeout((()=>o(t.uri,n)),500)}))),o(t.uri,n)},s=t=>{et.editor.setModelMarkers(t,e,[]);const n=String(t.uri),r=i.get(n);r&&(r.dispose(),i.delete(n))};et.editor.onDidCreateModel(a),et.editor.onWillDisposeModel((e=>{s(e),r(e.uri)})),et.editor.onDidChangeModelLanguage((e=>{s(e.model),a(e.model),r(e.model.uri)})),n.onDidChange((()=>{for(const t of et.editor.getModels())t.getModeId()===e&&(s(t),a(t))}));for(const e of et.editor.getModels())a(e)}(n,t,e),et.languages.setLanguageConfiguration(n,ln)}var dn=function(e,t){const n=new et.Emitter;let i={validate:!0,schemas:[],enableSchemaRequest:!1};const r={get onDidChange(){return n.event},get languageId(){return"yaml"},get diagnosticsOptions(){return i},setDiagnosticsOptions(e){i=e||{},n.fire(r)}};return r}();et.languages.yaml={yamlDefaults:dn},et.languages.register({id:"yaml",extensions:[".yaml",".yml"],aliases:["YAML","yaml","YML","yml"],mimetypes:["application/x-yaml"]}),et.languages.onLanguage("yaml",(()=>{un(dn)}));var pn=n(68);const{Uri:gn,editor:fn}=Qe.monaco,mn="http://elastic.co/cloud_defend.json",bn=gn.parse(mn),hn=c.i18n.translate("xpack.cloudDefend.alertActionRequired",{defaultMessage:'The alert action is required when "block" action used.'}),jn=c.i18n.translate("xpack.cloudDefend.controlYamlHelp",{defaultMessage:'Configure your policy by creating "file" or "process" selectors and responses below.'}),{editor:vn}=Qe.monaco,xn=({policy:e,onChange:t,show:n})=>{var r,l;const u=(()=>{const{euiTheme:e}=Object(o.useEuiTheme)(),{border:t}=e;return Object(i.useMemo)((()=>({yamlEditor:{height:"500px",border:t.thin},hide:{visibility:"hidden",position:"absolute"}})),[t.thin])})(),[d,p]=Object(i.useState)([]),[g,f]=Object(i.useState)([]),b=Object(s.b)(e,a.b),h=(null==b||null===(r=b.vars)||void 0===r||null===(l=r.configuration)||void 0===l?void 0:l.value)||"",j=(e=>Object(i.useMemo)((()=>{const{selectors:t}=Object(s.c)(e),n={...pn};if(n.$defs.fileResponse.properties.match.items){const e=n.$defs.fileResponse.properties,i={enum:t.filter((e=>"file"===e.type)).map((e=>e.name))};e.match.items=i,e.exclude.items=i}if(n.$defs.processResponse.properties.match.items){const e=n.$defs.processResponse.properties,i={enum:t.filter((e=>"process"===e.type)).map((e=>e.name))};e.match.items=i,e.exclude.items=i}!function(e={}){et.languages.yaml.yamlDefaults.setDiagnosticsOptions(e)}({validate:!0,completion:!0,hover:!0,schemas:[{uri:mn,fileMatch:[String(bn)],schema:n}]});let i=fn.getModel(bn);return null===i&&(i=fn.createModel("","yaml",bn)),i}),[e]))(h),v=Object(i.useCallback)((e=>{const t=[],{selectors:n,responses:i}=Object(s.c)(e);return t.push(...function(e,t){const n=[],i=le(e,t);return Object.values(i).forEach((e=>{e>ae.e&&n.push(c.i18n.translate("xpack.cloudDefend.errorMaxSelectorsResponsesExceeded",{defaultMessage:"You cannot exceed {max} selectors + responses for a given type e.g file, process",values:{max:ae.e}}))})),n}(n,i)),t.push(...pe(n,i)),n.forEach((e=>{Object.keys(e).map((n=>{var i;const r=n;if("stringArray"===(null===(i=te[r])||void 0===i?void 0:i.type)){const n=e[r];t.push(...ge(r,n))}}))})),i.forEach((e=>{e.actions&&e.actions.includes("block")&&!e.actions.includes("alert")&&t.push(hn)})),Object(m.uniq)(t)}),[]);Object(i.useEffect)((()=>{if(!n)return;const i=v(h);i.length!==g.length&&f(i);const r=vn.onDidChangeMarkers((([n])=>{const r=vn.getModelMarkers({resource:n}).map((e=>({line:e.startLineNumber,message:e.message})));i.length===g.length&&JSON.stringify(r)===JSON.stringify(d)||(t({isValid:0===i.length&&0===r.length,updatedPolicy:e}),p(r))}));return()=>{r.dispose()}}),[d,t,e,g.length,v,h,n]);const x=Object(i.useCallback)((i=>{if(n&&null!=b&&b.vars){b.vars.configuration.value=i;const n=v(i);f(n),t({isValid:0===n.length&&0===d.length,updatedPolicy:e})}}),[d.length,null==b?void 0:b.vars,t,e,n,v]);return Object(me.jsx)(o.EuiFlexGroup,{direction:"column",css:!n&&u.hide},Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiText,{color:"subdued",size:"s"},jn),Object(me.jsx)(o.EuiSpacer,{size:"s"}),g.length>0&&Object(me.jsx)(o.EuiForm,{"data-test-subj":"cloudDefendAdditionalErrors",isInvalid:!0,error:g}),Object(me.jsx)("div",{css:u.yamlEditor},Object(me.jsx)(Ye.CodeEditor,{width:"100%",languageId:Ye.YamlLang,options:{wordWrap:"off",model:j,automaticLayout:!0,padding:{top:10,bottom:10}},onChange:x,value:h})),Object(me.jsx)(o.EuiSpacer,{size:"s"})))},yn="general",On="yaml",kn=({policy:e,onChange:t})=>{const[n,r]=Object(i.useState)(yn),[a,s]=Object(i.useState)(!0),c=Object(i.useCallback)((()=>{r(yn)}),[]),l=Object(i.useCallback)((()=>{r(On)}),[]),u=n===yn,d=n===On,p=Object(i.useCallback)((n=>{n.updatedPolicy=e,t(n),s(n.isValid)}),[t,e]),m=Object(i.useCallback)((n=>{n.updatedPolicy=e,t(n),s(n.isValid)}),[t,e]);return Object(me.jsx)(o.EuiFlexGroup,{direction:"column"},Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiTabs,null,Object(me.jsx)(o.EuiTab,{id:yn,onClick:c,isSelected:u,"data-test-subj":"cloud-defend-btngeneralview",disabled:!a},g),Object(me.jsx)(o.EuiTab,{id:On,onClick:l,isSelected:d,"data-test-subj":"cloud-defend-btnyamlview",disabled:!a},f))),Object(me.jsx)(o.EuiFlexItem,null,u&&Object(me.jsx)(ke,{show:u,policy:e,onChange:p}),Object(me.jsx)(xn,{show:d,policy:e,onChange:m})))},En=({policy:e,onChange:t})=>{const[n,r]=Object(i.useState)(!1),c=Object(s.b)(e,a.b),g=!(null==c||!c.enabled),f=Object(i.useCallback)((i=>{c&&(c.enabled=i.target.checked,t({isValid:!n,updatedPolicy:{...e}}))}),[c,t,n,e]),m=Object(i.useCallback)((i=>{const r=i.currentTarget.value;t({isValid:!n,updatedPolicy:{...e,name:r}})}),[t,n,e]),b=Object(i.useCallback)((i=>{const r=i.currentTarget.value;t({isValid:!n,updatedPolicy:{...e,description:r}})}),[t,n,e]),h=Object(i.useCallback)((e=>{r(!e.isValid),t(e)}),[t]);return Object(me.jsx)(o.EuiFlexGroup,{direction:"column"},Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiForm,{component:"form"},Object(me.jsx)(o.EuiFormRow,{label:l,fullWidth:!0},Object(me.jsx)(o.EuiFieldText,{fullWidth:!0,name:"name",value:e.name,onChange:m,"data-test-subj":"cloud-defend-policy-name"})),Object(me.jsx)(o.EuiFormRow,{label:u,fullWidth:!0},Object(me.jsx)(o.EuiTextArea,{fullWidth:!0,name:"name",value:e.description,onChange:b,"data-test-subj":"cloud-defend-policy-description",compressed:!0})),Object(me.jsx)(o.EuiHorizontalRule,null),Object(me.jsx)(o.EuiFormRow,{fullWidth:!0},Object(me.jsx)(o.EuiFlexItem,null,Object(me.jsx)(o.EuiSwitch,{"data-test-subj":"cloud-defend-controltoggle",label:d,checked:g,onChange:f}),Object(me.jsx)(o.EuiSpacer,{size:"s"}),Object(me.jsx)(o.EuiText,{color:"subdued",size:"s"},p))))),g&&Object(me.jsx)(kn,{"data-test-subj":"cloud-defend-controlsettings",policy:e,onChange:h}))},Cn=Object(i.memo)((({newPolicy:e,onChange:t})=>{const n=JSON.parse(JSON.stringify(e));return Object(me.jsx)(En,{policy:n,onChange:t})}));Cn.displayName="CloudDefendFleetPolicyReplaceDefineStepExtension"}}]);