"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyColors = exports.ColorPicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lighten_color = require("../../services/palettes/lighten_color");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const legacyColors = ['#3F6833', '#967302', '#2F575E', '#99440A', '#58140C', '#052B51', '#511749', '#3F2B5B', '#508642', '#CCA300', '#447EBC', '#C15C17', '#890F02', '#0A437C', '#6D1F62', '#584477', '#629E51', '#E5AC0E', '#64B0C8', '#E0752D', '#BF1B00', '#0A50A1', '#962D82', '#614D93', '#7EB26D', '#EAB839', '#6ED0E0', '#EF843C', '#E24D42', '#1F78C1', '#BA43A9', '#705DA0', '#9AC48A', '#F2C96D', '#65C5DB', '#F9934E', '#EA6460', '#5195CE', '#D683CE', '#806EB7', '#B7DBAB', '#F4D598', '#70DBED', '#F9BA8F', '#F29191', '#82B5D8', '#E5A8E2', '#AEA2E0', '#E0F9D7', '#FCEACA', '#CFFAFF', '#F9E2D2', '#FCE2DE', '#BADFF4', '#F9D9F9', '#DEDAF7'];
exports.legacyColors = legacyColors;
const euiColors = (0, _eui.euiPaletteColorBlind)({
  rotations: 4,
  order: 'group'
});
const visColorPickerColorBtnStyle = (0, _react2.css)`
  position: relative;
  input[type='radio'] {
    position: absolute;
    top: 50%;
    left: 50%;
    opacity: 0;
    transform: translate(-50%, -50%);
  }
`;
const visColorPickerValueDotStyle = (0, _react2.css)`
  cursor: pointer;
  &:hover {
    transform: scale(1.4);
  }
`;
const ColorPicker = ({
  onChange,
  color: selectedColor,
  label,
  useLegacyColors = true,
  colorIsOverwritten = true,
  onKeyDown,
  maxDepth,
  layerIndex
}) => {
  const legendColors = useLegacyColors ? legacyColors : euiColors;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const visColorPickerValueStyle = (0, _react.useMemo)(() => (0, _react2.css)`
      width: calc(${euiTheme.size.l} * 8);
    `, [euiTheme.size.l]);
  const visColorPickerValueDotSelectedStyle = (0, _react.useMemo)(() => (0, _react2.css)`
      border: ${euiTheme.size.xs} solid;
      border-radius: 100%;
    `, [euiTheme.size.xs]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "visColorPicker"
  }, /*#__PURE__*/_react.default.createElement("fieldset", null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("legend", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "charts.colorPicker.setColor.screenReaderDescription",
    defaultMessage: "Set color for value {legendDataLabel}",
    values: {
      legendDataLabel: label
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "none",
    css: visColorPickerValueStyle,
    className: "visColorPicker__value"
  }, legendColors.map(color => /*#__PURE__*/_react.default.createElement("label", {
    key: color,
    css: visColorPickerColorBtnStyle,
    className: "visColorPicker__colorBtn"
  }, /*#__PURE__*/_react.default.createElement("input", {
    type: "radio",
    onChange: e => onChange(color, e),
    value: selectedColor,
    name: "visColorPicker__radio",
    checked: color === selectedColor,
    onKeyDown: onKeyDown
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "dot",
    size: "l",
    color: selectedColor,
    css: [visColorPickerValueDotStyle, color === selectedColor ? visColorPickerValueDotSelectedStyle : null],
    className: "visColorPicker__valueDot",
    style: {
      color
    },
    "data-test-subj": `visColorPickerColor-${color}`
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, color)))))), legendColors.some(c => c === selectedColor || layerIndex && maxDepth && (0, _lighten_color.lightenColor)(c, layerIndex, maxDepth) === selectedColor) && colorIsOverwritten && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: e => onChange(null, e)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "charts.colorPicker.clearColor",
    defaultMessage: "Reset color"
  }))));
};
exports.ColorPicker = ColorPicker;