"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseSyncOptions = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function isDateHistogramSyncOption(syncOption) {
  return Boolean(syncOption && 'isDateHistogram' in syncOption);
}
const parseDatatable = dataTables => {
  const isDateHistogram = Boolean(dataTables.length) && dataTables.every(dataTable => dataTable.columns.some(c => {
    var _c$meta$sourceParams;
    return Boolean((_c$meta$sourceParams = c.meta.sourceParams) === null || _c$meta$sourceParams === void 0 ? void 0 : _c$meta$sourceParams.appliedTimeRange);
  }));
  const accessors = (0, _lodash.uniq)(dataTables.map(dataTable => {
    const column = dataTable.columns.find(c => c.meta.index && c.meta.field);
    if (column !== null && column !== void 0 && column.meta.index) {
      return `${column.meta.index}:${column.meta.field}`;
    }
  }).filter(Boolean));
  return {
    isDateHistogram,
    accessors
  };
};

/** @internal **/
const parseSyncOptions = syncOptions => isDateHistogramSyncOption(syncOptions) ? {
  isDateHistogram: syncOptions.isDateHistogram
} : parseDatatable(syncOptions.datatables);
exports.parseSyncOptions = parseSyncOptions;