"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _mime_types = require("../common/constants/mime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigSchema = _configSchema.schema.object({
  markdownPlugins: _configSchema.schema.object({
    lens: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  files: _configSchema.schema.object({
    allowedMimeTypes: _configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }), {
      defaultValue: _mime_types.ALLOWED_MIME_TYPES
    }),
    // intentionally not setting a default here so that we can determine if the user set it
    maxSize: _configSchema.schema.maybe(_configSchema.schema.number({
      min: 0
    }))
  }),
  stack: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    })
  })
});
exports.ConfigSchema = ConfigSchema;