"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateDuplicatedCustomFieldKeysInRequest = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Throws an error if the request has custom fields with duplicated keys.
 */
const validateDuplicatedCustomFieldKeysInRequest = ({
  requestCustomFields = []
}) => {
  const uniqueKeys = new Set();
  const duplicatedKeys = new Set();
  requestCustomFields.forEach(item => {
    if (uniqueKeys.has(item.key)) {
      duplicatedKeys.add(item.key);
    } else {
      uniqueKeys.add(item.key);
    }
  });
  if (duplicatedKeys.size > 0) {
    throw _boom.default.badRequest(`Invalid duplicated custom field keys in request: ${Array.from(duplicatedKeys.values())}`);
  }
};
exports.validateDuplicatedCustomFieldKeysInRequest = validateDuplicatedCustomFieldKeysInRequest;