"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateCase = void 0;
var _reactQuery = require("@tanstack/react-query");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_toast = require("../common/use_cases_toast");
var _constants = require("./constants");
var _use_on_refresh_case_view_page = require("../components/case_view/use_on_refresh_case_view_page");
var _utils = require("./utils");
var _kibana = require("../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateCase = () => {
  const toasts = (0, _kibana.useToasts)();
  const {
    showErrorToast
  } = (0, _use_cases_toast.useCasesToast)();
  const refreshCaseViewPage = (0, _use_on_refresh_case_view_page.useRefreshCaseViewPage)();
  return (0, _reactQuery.useMutation)(request => (0, _api.patchCase)({
    caseId: request.caseData.id,
    updatedCase: {
      [request.updateKey]: request.updateValue
    },
    version: request.caseData.version
  }), {
    mutationKey: _constants.casesMutationsKeys.updateCase,
    onSuccess: (response, request) => {
      refreshCaseViewPage();
      const successToaster = (0, _utils.createUpdateSuccessToaster)(request.caseData, response[0], request.updateKey, request.updateValue);
      toasts.addSuccess(successToaster);
    },
    onError: error => {
      showErrorToast(error, {
        title: i18n.ERROR_TITLE
      });
    }
  });
};
exports.useUpdateCase = useUpdateCase;