"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenLensButton = void 0;
var _esQuery = require("@kbn/es-query");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../common/lib/kibana");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OpenLensButtonComponent = ({
  attachmentId,
  attributes,
  timeRange
}) => {
  const {
    lens: {
      navigateToPrefilledEditor,
      canUseEditor
    }
  } = (0, _kibana.useKibana)().services;
  const onClick = (0, _react.useCallback)(() => {
    navigateToPrefilledEditor({
      id: attachmentId,
      timeRange,
      attributes
    }, {
      openInNewTab: true
    });
  }, [attachmentId, attributes, navigateToPrefilledEditor, timeRange]);
  const hasLensPermissions = canUseEditor();
  const isESQLQuery = (0, _esQuery.isOfAggregateQueryType)(attributes.state.query);
  if (!hasLensPermissions || isESQLQuery) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _translations.OPEN_IN_VISUALIZATION,
    "data-test-subj": "cases-open-in-visualization-btn",
    iconType: "lensApp",
    isDisabled: !hasLensPermissions,
    onClick: onClick
  }, _translations.OPEN_IN_VISUALIZATION);
};
OpenLensButtonComponent.displayName = 'OpenLensButton';
const OpenLensButton = /*#__PURE__*/_react.default.memo(OpenLensButtonComponent);
exports.OpenLensButton = OpenLensButton;