"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/kibana-react-plugin/common");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LENS_VISUALIZATION_HEIGHT = 200;
const Container = _styledComponents.default.div`
  min-height: ${LENS_VISUALIZATION_HEIGHT}px;
`;

// when displaying chart in modal the tooltip is render under the modal
const LensChartTooltipFix = (0, _common.createGlobalStyle)`
  div.euiOverlayMask[data-relative-to-header=above] ~ [id^='echTooltipPortal'] {
    z-index: ${({
  theme
}) => theme.eui.euiZLevel7} !important;
  }
`;
const LensRendererComponent = ({
  attributes,
  timeRange
}) => {
  const {
    lens: {
      EmbeddableComponent
    }
  } = (0, _kibana.useKibana)().services;
  if (!attributes) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: "",
    style: {
      height: LENS_VISUALIZATION_HEIGHT
    },
    timeRange: timeRange,
    attributes: attributes,
    renderMode: "view",
    disableTriggers: true,
    executionContext: {
      type: 'cases'
    },
    syncTooltips: false,
    syncCursor: false
  }), /*#__PURE__*/_react.default.createElement(LensChartTooltipFix, null));
};
LensRendererComponent.displayName = 'LensRenderer';
const LensRenderer = /*#__PURE__*/_react.default.memo(LensRendererComponent);
exports.LensRenderer = LensRenderer;