"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActionsActivityBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _filter_activity = require("./filter_activity");
var _sort_activity = require("./sort_activity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserActionsActivityBar = /*#__PURE__*/_react.default.memo(({
  params,
  onUserActionsActivityChanged,
  userActionsStats,
  isLoading
}) => {
  const handleFilterChange = type => {
    onUserActionsActivityChanged({
      ...params,
      type
    });
  };
  const handleOrderChange = sortOrder => {
    onUserActionsActivityChanged({
      ...params,
      sortOrder
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    justifyContent: "spaceBetween",
    "data-test-subj": "user-actions-activity-bar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_filter_activity.FilterActivity, {
    type: params.type,
    onFilterChange: handleFilterChange,
    userActionsStats: userActionsStats,
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sort_activity.SortActivity, {
    sortOrder: params.sortOrder,
    onOrderChange: handleOrderChange,
    isLoading: isLoading
  })));
});
exports.UserActionsActivityBar = UserActionsActivityBar;
UserActionsActivityBar.displayName = 'UserActionsActivityBar';